/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.RChain;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.RuleProfiler;
import de.tudresden.inf.lat.jcel.core.algorithm.rulebased.SChain;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR1SRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR2SRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR3SRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR4RRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR4SRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR5RRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR6RRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR6RTrRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR7RRule;
import de.tudresden.inf.lat.jcel.core.completion.basic.CR7SRule;
import de.tudresden.inf.lat.jcel.core.completion.common.RObserverRule;
import de.tudresden.inf.lat.jcel.core.completion.common.SObserverRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR3SExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR4RExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR4SExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR5RExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR6RExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR6SExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR7RExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR8RExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR8SExtRule;
import de.tudresden.inf.lat.jcel.core.completion.ext.CR9RExtRule;
import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CompletionRuleChainSelector {
    private RChain chainR = new RChain(new ArrayList<RObserverRule>());
    private SChain chainS = new SChain(new ArrayList<SObserverRule>());
    private final OntologyExpressivity expressivity;

    public CompletionRuleChainSelector(OntologyExpressivity expressivity) {
        Objects.requireNonNull(expressivity);
        this.expressivity = expressivity;
        if (this.getOntologyExpressivity().hasInverseObjectProperty() || this.getOntologyExpressivity().hasFunctionalObjectProperty()) {
            this.activateExtendedRules();
        } else {
            this.activateSimpleRules();
            if (this.getOntologyExpressivity().hasSubPropertyChainOf()) {
                this.activatePropertyChainRules();
            } else if (this.getOntologyExpressivity().hasTransitiveObjectProperty()) {
                this.activateTransitivePropertyRules();
            }
        }
        if (this.getOntologyExpressivity().hasBottom()) {
            this.activateBottomRules();
        }
    }

    private void activateBottomRules() {
        ArrayList<SObserverRule> listS = new ArrayList<SObserverRule>();
        listS.addAll(this.chainS.getList());
        listS.add(new CR7SRule());
        this.chainS = new SChain(listS);
        ArrayList<RObserverRule> listR = new ArrayList<RObserverRule>();
        listR.addAll(this.chainR.getList());
        listR.add(new CR7RRule());
        this.chainR = new RChain(listR);
    }

    private void activateExtendedRules() {
        ArrayList<SObserverRule> listS = new ArrayList<SObserverRule>();
        listS.addAll(this.chainS.getList());
        listS.add(new CR1SRule());
        listS.add(new CR2SRule());
        listS.add(new CR3SExtRule());
        listS.add(new CR4SExtRule());
        listS.add(new CR6SExtRule());
        listS.add(new CR8SExtRule());
        this.chainS = new SChain(listS);
        ArrayList<RObserverRule> listR = new ArrayList<RObserverRule>();
        listR.addAll(this.chainR.getList());
        listR.add(new CR4RExtRule());
        listR.add(new CR5RExtRule());
        listR.add(new CR6RExtRule());
        listR.add(new CR7RExtRule());
        listR.add(new CR8RExtRule());
        listR.add(new CR9RExtRule());
        this.chainR = new RChain(listR);
    }

    public void activateProfiler() {
        List<SObserverRule> listS = this.chainS.getList();
        ArrayList<SObserverRule> listSWithProfiler = new ArrayList<SObserverRule>();
        listS.forEach(current -> listSWithProfiler.add(new RuleProfiler((SObserverRule)current)));
        this.chainS = new SChain(listSWithProfiler);
        List<RObserverRule> listR = this.chainR.getList();
        ArrayList<RObserverRule> listRWithProfiler = new ArrayList<RObserverRule>();
        listR.forEach(current -> listRWithProfiler.add(new RuleProfiler((RObserverRule)current)));
        this.chainR = new RChain(listRWithProfiler);
    }

    private void activatePropertyChainRules() {
        ArrayList<RObserverRule> listR = new ArrayList<RObserverRule>();
        listR.addAll(this.chainR.getList());
        listR.add(new CR6RRule());
        this.chainR = new RChain(listR);
    }

    private void activateSimpleRules() {
        ArrayList<SObserverRule> listS = new ArrayList<SObserverRule>();
        listS.addAll(this.chainS.getList());
        listS.add(new CR1SRule());
        listS.add(new CR2SRule());
        listS.add(new CR3SRule());
        listS.add(new CR4SRule());
        this.chainS = new SChain(listS);
        ArrayList<RObserverRule> listR = new ArrayList<RObserverRule>();
        listR.addAll(this.chainR.getList());
        listR.add(new CR4RRule());
        listR.add(new CR5RRule());
        this.chainR = new RChain(listR);
    }

    private void activateTransitivePropertyRules() {
        ArrayList<RObserverRule> listR = new ArrayList<RObserverRule>();
        listR.addAll(this.chainR.getList());
        listR.add(new CR6RTrRule());
        this.chainR = new RChain(listR);
    }

    public OntologyExpressivity getOntologyExpressivity() {
        return this.expressivity;
    }

    public RChain getRChain() {
        return this.chainR;
    }

    public SChain getSChain() {
        return this.chainS;
    }
}

