/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.algorithm.rulebased;

import de.tudresden.inf.lat.jcel.core.completion.common.ClassifierStatus;
import de.tudresden.inf.lat.jcel.core.completion.common.RObserverRule;
import de.tudresden.inf.lat.jcel.core.completion.common.SObserverRule;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class RuleProfiler
implements RObserverRule,
SObserverRule {
    private final RObserverRule rListener;
    private final SObserverRule sListener;
    private long successful = 0L;
    private long times = 0L;
    private long totalTime = 0L;

    public RuleProfiler(RObserverRule rule) {
        Objects.requireNonNull(rule);
        this.rListener = rule;
        this.sListener = null;
    }

    public RuleProfiler(SObserverRule rule) {
        Objects.requireNonNull(rule);
        this.sListener = rule;
        this.rListener = null;
    }

    @Override
    public boolean apply(ClassifierStatus status, int subClass, int superClass) {
        Objects.requireNonNull(status);
        long start = new Date().getTime();
        boolean ret = this.sListener.apply(status, subClass, superClass);
        this.totalTime += new Date().getTime() - start;
        ++this.times;
        if (ret) {
            ++this.successful;
        }
        return ret;
    }

    @Override
    public boolean apply(ClassifierStatus status, int property, int leftClass, int rightClass) {
        Objects.requireNonNull(status);
        long start = Calendar.getInstance().getTimeInMillis();
        boolean ret = this.rListener.apply(status, property, leftClass, rightClass);
        this.totalTime += Calendar.getInstance().getTimeInMillis() - start;
        ++this.times;
        if (ret) {
            ++this.successful;
        }
        return ret;
    }

    public long getSuccessful() {
        return this.successful;
    }

    public long getTimes() {
        return this.times;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        if (Objects.nonNull(this.rListener)) {
            sbuf.append(this.rListener.toString());
        }
        if (Objects.nonNull(this.sListener)) {
            sbuf.append(this.sListener.toString());
        }
        sbuf.append(" ok=");
        sbuf.append(this.getSuccessful());
        sbuf.append(" all=");
        sbuf.append(this.getTimes());
        sbuf.append(" time=");
        sbuf.append(this.getTotalTime());
        sbuf.append(" ms \n");
        return sbuf.toString();
    }
}

