/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.ArraySet;
import de.tudresden.inf.lat.jcel.core.graph.IntegerBinaryRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IntegerBinaryRelationImpl
implements IntegerBinaryRelation {
    private final Map<Integer, Collection<Integer>> byFirstComp = new ConcurrentHashMap<Integer, Collection<Integer>>();
    private final Map<Integer, Collection<Integer>> bySecondComp = new ConcurrentHashMap<Integer, Collection<Integer>>();

    public boolean add(int elem) {
        boolean ret = false;
        ret |= this.addTo(elem, this.byFirstComp);
        return ret |= this.addTo(elem, this.bySecondComp);
    }

    public boolean add(int first, int second) {
        boolean ret = false;
        ret |= this.add(first);
        ret |= this.add(second);
        Collection<Integer> byFirst = this.byFirstComp.get(first);
        Collection<Integer> bySecond = this.bySecondComp.get(second);
        boolean found = false;
        found = byFirst.size() < bySecond.size() ? byFirst.contains(second) : bySecond.contains(first);
        if (!found) {
            ret |= byFirst.add(second);
            ret |= bySecond.add(first);
        }
        return ret;
    }

    private boolean addTo(int elem, Map<Integer, Collection<Integer>> map) {
        boolean ret = false;
        if (Objects.isNull(map.get(elem))) {
            map.put(elem, new ArraySet());
            ret = true;
        }
        return ret;
    }

    @Override
    public boolean contains(int first, int second) {
        boolean ret = false;
        Collection<Integer> byFirst = this.byFirstComp.get(first);
        ret = Objects.nonNull(byFirst) && byFirst.contains(second);
        return ret;
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerBinaryRelation) {
            IntegerBinaryRelation other = (IntegerBinaryRelation)o;
            ret = this.getElements().equals(other.getElements());
            ret = ret && this.getElements().stream().allMatch(elem -> this.getByFirst((int)elem).equals(other.getByFirst((int)elem)));
        }
        return ret;
    }

    @Override
    public Collection<Integer> getByFirst(int first) {
        Collection<Integer> ret = Collections.emptySet();
        Collection<Integer> set = this.byFirstComp.get(first);
        if (Objects.nonNull(set)) {
            ret = Collections.unmodifiableCollection(set);
        }
        return ret;
    }

    @Override
    public Collection<Integer> getBySecond(int second) {
        Collection<Integer> ret = Collections.emptySet();
        Collection<Integer> set = this.bySecondComp.get(second);
        if (Objects.nonNull(set)) {
            ret = Collections.unmodifiableCollection(set);
        }
        return ret;
    }

    public long getDeepSize() {
        long ret = 0L;
        ret += (long)this.byFirstComp.keySet().stream().map(key -> this.byFirstComp.get(key).size()).reduce(0, (accum, elem) -> accum + elem).intValue();
        return ret += (long)this.bySecondComp.keySet().stream().map(key -> this.bySecondComp.get(key).size()).reduce(0, (accum, elem) -> accum + elem).intValue();
    }

    @Override
    public Set<Integer> getElements() {
        return this.byFirstComp.keySet();
    }

    public int hashCode() {
        return this.byFirstComp.hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        Set<Integer> elements = this.getElements();
        sbuf.append("[");
        elements.forEach(firstComponent -> {
            Collection<Integer> connectedElem = this.getByFirst((int)firstComponent);
            connectedElem.forEach(secondComponent -> {
                sbuf.append(" (");
                sbuf.append(firstComponent);
                sbuf.append(",");
                sbuf.append(secondComponent);
                sbuf.append(")");
            });
        });
        sbuf.append(" ]");
        return sbuf.toString();
    }
}

