/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.core.graph;

import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerBidirectionalGraph;
import de.tudresden.inf.lat.jcel.core.graph.IntegerSubsumerGraphImpl;
import java.util.Collection;
import java.util.Objects;

public class IntegerSubsumerBidirectionalGraphImpl
implements IntegerSubsumerBidirectionalGraph {
    private final IntegerSubsumerGraphImpl graph;
    private final IntegerSubsumerGraphImpl invGraph;

    public IntegerSubsumerBidirectionalGraphImpl(int bottom, int top) {
        this.graph = new IntegerSubsumerGraphImpl(bottom, top);
        this.invGraph = new IntegerSubsumerGraphImpl(top, bottom);
    }

    public void add(int vertex) {
        this.graph.add(vertex);
        this.invGraph.add(vertex);
    }

    public void addAncestor(int subId, int superId) {
        this.add(subId);
        this.add(superId);
        this.graph.addAncestor(subId, superId);
        this.invGraph.addAncestor(superId, subId);
    }

    @Override
    public boolean containsPair(int subsumee, int subsumer) {
        return Objects.nonNull(this.getSubsumers(subsumee)) && this.getSubsumers(subsumee).contains(subsumer);
    }

    public boolean equals(Object o) {
        boolean ret;
        boolean bl = ret = this == o;
        if (!ret && o instanceof IntegerSubsumerBidirectionalGraph) {
            IntegerSubsumerBidirectionalGraph other = (IntegerSubsumerBidirectionalGraph)o;
            ret = this.getBottomElement() == other.getBottomElement() && this.getTopElement() == other.getTopElement() && this.getElements().equals(other.getElements());
            ret = ret && this.getElements().stream().allMatch(elem -> this.getSubsumers((int)elem).equals(other.getSubsumers((int)elem)));
        }
        return ret;
    }

    @Override
    public int getBottomElement() {
        return this.graph.getBottomElement();
    }

    @Override
    public Collection<Integer> getElements() {
        return this.graph.getElements();
    }

    @Override
    public Collection<Integer> getSubsumees(int vertex) {
        return this.invGraph.getSubsumers(vertex);
    }

    @Override
    public Collection<Integer> getSubsumers(int vertex) {
        return this.graph.getSubsumers(vertex);
    }

    @Override
    public int getTopElement() {
        return this.graph.getTopElement();
    }

    public int hashCode() {
        return this.graph.hashCode();
    }

    public void retainAll(Collection<Integer> collection) {
        Objects.requireNonNull(collection);
        this.graph.retainAll(collection);
        this.invGraph.retainAll(collection);
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        this.graph.getElements().forEach(id -> {
            Collection<Integer> related = this.getSubsumers((int)id);
            ret.append(id);
            ret.append(" (");
            ret.append(related.size());
            ret.append(") : ");
            related.forEach(elem -> ret.append(elem + " "));
            ret.append("\n");
        });
        return ret.toString();
    }
}

