/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class IntegerDifferentIndividualsAxiom
implements ComplexIntegerAxiom {
    private final Set<Integer> individuals;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerDifferentIndividualsAxiom(Set<Integer> individualSet, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(individualSet);
        Objects.requireNonNull(annotations);
        this.individuals = Collections.unmodifiableSet(individualSet);
        this.annotations = annotations;
        this.hashCode = this.individuals.hashCode() + 31 * this.annotations.hashCode();
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerDifferentIndividualsAxiom) {
            IntegerDifferentIndividualsAxiom other = (IntegerDifferentIndividualsAxiom)obj;
            ret = this.getIndividuals().equals(other.getIndividuals()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public Set<Integer> getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.unmodifiableSet(this.individuals);
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("DifferentIndividuals");
        sbuf.append("(");
        Set<Integer> individualSet = this.getIndividuals();
        individualSet.forEach(individual -> {
            sbuf.append(individual.toString());
            sbuf.append(" ");
        });
        sbuf.append(")");
        return sbuf.toString();
    }
}

