/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.complex;

import de.tudresden.inf.lat.jcel.coreontology.axiom.IntegerAnnotation;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class IntegerInverseObjectPropertiesAxiom
implements ComplexIntegerAxiom {
    private final IntegerObjectPropertyExpression firstProperty;
    private final Set<Integer> objectPropertiesInSignature;
    private final IntegerObjectPropertyExpression secondProperty;
    private final Set<IntegerAnnotation> annotations;
    private final int hashCode;

    IntegerInverseObjectPropertiesAxiom(IntegerObjectPropertyExpression first, IntegerObjectPropertyExpression second, Set<IntegerAnnotation> annotations) {
        Objects.requireNonNull(first);
        Objects.requireNonNull(second);
        Objects.requireNonNull(annotations);
        this.firstProperty = first;
        this.secondProperty = second;
        HashSet<Integer> objectPropertiesInSignature = new HashSet<Integer>();
        objectPropertiesInSignature.addAll(this.firstProperty.getObjectPropertiesInSignature());
        objectPropertiesInSignature.addAll(this.secondProperty.getObjectPropertiesInSignature());
        this.objectPropertiesInSignature = Collections.unmodifiableSet(objectPropertiesInSignature);
        this.annotations = annotations;
        this.hashCode = this.firstProperty.hashCode() + 31 * (this.secondProperty.hashCode() + 31 * this.annotations.hashCode());
    }

    @Override
    public <T> T accept(ComplexIntegerAxiomVisitor<T> visitor) {
        Objects.requireNonNull(visitor);
        return visitor.visit(this);
    }

    public boolean equals(Object obj) {
        boolean ret;
        boolean bl = ret = this == obj;
        if (!ret && obj instanceof IntegerInverseObjectPropertiesAxiom) {
            IntegerInverseObjectPropertiesAxiom other = (IntegerInverseObjectPropertiesAxiom)obj;
            ret = this.getFirstProperty().equals(other.getFirstProperty()) && this.getSecondProperty().equals(other.getSecondProperty()) && this.getAnnotations().equals(other.getAnnotations());
        }
        return ret;
    }

    @Override
    public Set<Integer> getClassesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDataPropertiesInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getDatatypesInSignature() {
        return Collections.emptySet();
    }

    public IntegerObjectPropertyExpression getFirstProperty() {
        return this.firstProperty;
    }

    @Override
    public Set<Integer> getIndividualsInSignature() {
        return Collections.emptySet();
    }

    @Override
    public Set<Integer> getObjectPropertiesInSignature() {
        return Collections.unmodifiableSet(this.objectPropertiesInSignature);
    }

    public IntegerObjectPropertyExpression getSecondProperty() {
        return this.secondProperty;
    }

    @Override
    public Set<IntegerAnnotation> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("InverseObjectProperties");
        sbuf.append("(");
        sbuf.append(this.getFirstProperty());
        sbuf.append(" ");
        sbuf.append(this.getSecondProperty());
        sbuf.append(")");
        return sbuf.toString();
    }
}

