/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.extension;

import de.tudresden.inf.lat.jcel.coreontology.datatype.OntologyExpressivity;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiomVisitor;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerClassDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDataPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDifferentIndividualsAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDisjointClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerEquivalentObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseFunctionalObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNamedIndividualDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerNegativeObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyAssertionAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerObjectPropertyDeclarationAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerPropertyRangeAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerReflexiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSameIndividualAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubObjectPropertyOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerTransitiveObjectPropertyAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerExpressionAnalyzer;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import java.util.HashSet;
import java.util.Objects;

public class ComplexIntegerAxiomAnalyzer
implements ComplexIntegerAxiomVisitor<Boolean>,
OntologyExpressivity {
    private final IntegerExpressionAnalyzer expressionAnalyzer = new IntegerExpressionAnalyzer();
    private boolean hasBottom = false;
    private boolean hasDatatype = false;
    private boolean hasFunctionalObjectProperty = false;
    private boolean hasIndividual = false;
    private boolean hasInverseObjectProperty = false;
    private boolean hasReflexiveObjectProperty = false;
    private boolean hasSubObjectPropertyOf = false;
    private boolean hasSubPropertyChainOf = false;
    private boolean hasTransitiveObjectProperty = false;

    @Override
    public boolean hasBottom() {
        return this.hasBottom || this.expressionAnalyzer.hasBottom();
    }

    @Override
    public boolean hasDatatype() {
        return this.hasDatatype || this.expressionAnalyzer.hasDatatype();
    }

    @Override
    public boolean hasFunctionalObjectProperty() {
        return this.hasFunctionalObjectProperty;
    }

    @Override
    public boolean hasIndividual() {
        return this.hasIndividual;
    }

    @Override
    public boolean hasInverseObjectProperty() {
        return this.hasInverseObjectProperty || this.expressionAnalyzer.hasInverseObjectProperty();
    }

    @Override
    public boolean hasNominal() {
        return this.expressionAnalyzer.hasNominal();
    }

    @Override
    public boolean hasReflexiveObjectProperty() {
        return this.hasReflexiveObjectProperty;
    }

    @Override
    public boolean hasSubObjectPropertyOf() {
        return this.hasSubObjectPropertyOf;
    }

    @Override
    public boolean hasSubPropertyChainOf() {
        return this.hasSubPropertyChainOf;
    }

    @Override
    public boolean hasTransitiveObjectProperty() {
        return this.hasTransitiveObjectProperty;
    }

    @Override
    public Boolean visit(IntegerClassAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasIndividual = true;
        return axiom.getClassExpression().accept(this.expressionAnalyzer);
    }

    @Override
    public Boolean visit(IntegerClassDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return true;
    }

    @Override
    public Boolean visit(IntegerDataPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasDatatype = true;
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerDataPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasDatatype = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerDifferentIndividualsAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom = true;
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerDisjointClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom = true;
        return this.expressionAnalyzer.visit(axiom.getClassExpressions());
    }

    @Override
    public Boolean visit(IntegerEquivalentClassesAxiom axiom) {
        Objects.requireNonNull(axiom);
        return this.expressionAnalyzer.visit(axiom.getClassExpressions());
    }

    @Override
    public Boolean visit(IntegerEquivalentObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        return true;
    }

    @Override
    public Boolean visit(IntegerFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasFunctionalObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerInverseFunctionalObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasFunctionalObjectProperty = true;
        this.hasInverseObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerInverseObjectPropertiesAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasInverseObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerNamedIndividualDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerNegativeObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasBottom = true;
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerObjectPropertyAssertionAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerObjectPropertyDeclarationAxiom axiom) {
        Objects.requireNonNull(axiom);
        return true;
    }

    @Override
    public Boolean visit(IntegerPropertyRangeAxiom axiom) {
        Objects.requireNonNull(axiom);
        return axiom.getRange().accept(this.expressionAnalyzer);
    }

    @Override
    public Boolean visit(IntegerReflexiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasReflexiveObjectProperty = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerSameIndividualAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasIndividual = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerSubClassOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        HashSet<IntegerClassExpression> set = new HashSet<IntegerClassExpression>();
        set.add(axiom.getSubClass());
        set.add(axiom.getSuperClass());
        return this.expressionAnalyzer.visit(set);
    }

    @Override
    public Boolean visit(IntegerSubObjectPropertyOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasSubObjectPropertyOf = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerSubPropertyChainOfAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasSubPropertyChainOf = true;
        this.hasSubObjectPropertyOf = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerTransitiveObjectPropertyAxiom axiom) {
        Objects.requireNonNull(axiom);
        this.hasTransitiveObjectProperty = true;
        return true;
    }
}

