/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.axiom.extension;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpressionVisitor;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataHasValue;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataSomeValuesFrom;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerNamedIndividual;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectIntersectionOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectInverseOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectOneOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectSomeValuesFrom;
import java.util.Objects;
import java.util.Set;

public class IntegerExpressionAnalyzer
implements IntegerClassExpressionVisitor<Boolean> {
    private boolean hasBottom = false;
    private boolean hasDatatype = false;
    private boolean hasInverseObjectProperty = false;
    private boolean hasNominal = false;

    public boolean hasBottom() {
        return this.hasBottom;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public boolean hasInverseObjectProperty() {
        return this.hasInverseObjectProperty;
    }

    public boolean hasNominal() {
        return this.hasNominal;
    }

    @Override
    public Boolean visit(IntegerClass classExpression) {
        Objects.requireNonNull(classExpression);
        this.hasBottom |= classExpression.getId() == IntegerEntityManager.bottomClassId.intValue();
        return true;
    }

    @Override
    public Boolean visit(IntegerDataHasValue classExpression) {
        Objects.requireNonNull(classExpression);
        this.hasDatatype = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerDataSomeValuesFrom classExpression) {
        Objects.requireNonNull(classExpression);
        this.hasDatatype = true;
        return classExpression.getFiller().accept(this);
    }

    @Override
    public Boolean visit(IntegerNamedIndividual namedIndividual) {
        Objects.requireNonNull(namedIndividual);
        return true;
    }

    @Override
    public Boolean visit(IntegerObjectIntersectionOf classExpression) {
        Objects.requireNonNull(classExpression);
        return this.visit(classExpression.getOperands());
    }

    @Override
    public Boolean visit(IntegerObjectOneOf classExpression) {
        Objects.requireNonNull(classExpression);
        this.hasNominal = true;
        return true;
    }

    @Override
    public Boolean visit(IntegerObjectSomeValuesFrom classExpression) {
        Objects.requireNonNull(classExpression);
        boolean fillerAcc = classExpression.getFiller().accept(this);
        IntegerObjectPropertyExpression prop = classExpression.getProperty();
        if (prop instanceof IntegerObjectInverseOf) {
            this.hasInverseObjectProperty = true;
        }
        return fillerAcc;
    }

    protected Boolean visit(Set<IntegerClassExpression> classSet) {
        Objects.requireNonNull(classSet);
        return classSet.stream().map(expr -> expr.accept(this)).reduce(true, (accum, elem) -> accum != false && elem != false);
    }
}

