/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerDisjointClassesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectIntersectionOf;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerDisjoint
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerDisjoint(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerDisjointClassesAxiom) {
            ret = this.applyRule((IntegerDisjointClassesAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerDisjointClassesAxiom disjointAxiom) {
        Set<IntegerClassExpression> classExpressionSet = disjointAxiom.getClassExpressions();
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        classExpressionSet.forEach(firstClassExpression -> classExpressionSet.forEach(secondClassExpression -> {
            if (!firstClassExpression.equals(secondClassExpression)) {
                HashSet<IntegerClassExpression> pair = new HashSet<IntegerClassExpression>();
                pair.add((IntegerClassExpression)firstClassExpression);
                pair.add((IntegerClassExpression)secondClassExpression);
                IntegerObjectIntersectionOf intersection = this.getOntologyObjectFactory().getDataTypeFactory().createObjectIntersectionOf(pair);
                IntegerSubClassOfAxiom subClassAxiom = this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(intersection, this.getOntologyObjectFactory().getDataTypeFactory().createClass(IntegerEntityManager.bottomClassId), disjointAxiom.getAnnotations());
                ret.add(subClassAxiom);
            }
        }));
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

