/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubClassOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR1_7
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR1_7(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerSubClassOfAxiom) {
            ret = this.applyRule((IntegerSubClassOfAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerSubClassOfAxiom classAxiom) {
        Set<IntegerAxiom> ret = Collections.emptySet();
        IntegerClassExpression superClass = classAxiom.getSuperClass();
        if (superClass.containsBottom() && !superClass.isLiteral()) {
            ret = new HashSet<IntegerAxiom>();
            IntegerSubClassOfAxiom axiom = this.getOntologyObjectFactory().getComplexAxiomFactory().createSubClassOfAxiom(classAxiom.getSubClass(), this.getOntologyObjectFactory().getDataTypeFactory().createClass(IntegerEntityManager.bottomClassId), classAxiom.getAnnotations());
            ret.add(axiom);
        }
        return ret;
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

