/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityType;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerSubPropertyChainOfAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.ontology.normalization.NormalizationRule;
import de.tudresden.inf.lat.jcel.ontology.normalization.ObjectPropertyIdFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NormalizerNR2_1
implements NormalizationRule {
    private final IntegerOntologyObjectFactory ontologyObjectFactory;

    public NormalizerNR2_1(IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(factory);
        this.ontologyObjectFactory = factory;
    }

    @Override
    public Set<IntegerAxiom> apply(IntegerAxiom axiom) {
        Objects.requireNonNull(axiom);
        Set<IntegerAxiom> ret = Collections.emptySet();
        if (axiom instanceof IntegerSubPropertyChainOfAxiom) {
            ret = this.applyRule((IntegerSubPropertyChainOfAxiom)axiom);
        }
        return ret;
    }

    private Set<IntegerAxiom> applyRule(IntegerSubPropertyChainOfAxiom propertyAxiom) {
        HashSet<IntegerAxiom> ret = new HashSet<IntegerAxiom>();
        List<IntegerObjectPropertyExpression> propertyList = propertyAxiom.getPropertyChain();
        Integer superProperty = this.getObjectPropertyId(propertyAxiom.getSuperProperty());
        while (propertyList.size() > 2) {
            int lastPos = propertyList.size() - 1;
            Integer lastPropertyName = this.getObjectPropertyId(propertyList.get(lastPos));
            Integer newPropertyName = this.getOntologyObjectFactory().getEntityManager().createAnonymousEntity(IntegerEntityType.OBJECT_PROPERTY, true);
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRI3Axiom(newPropertyName, lastPropertyName, superProperty, propertyAxiom.getAnnotations()));
            propertyList = propertyList.subList(0, lastPos);
            superProperty = newPropertyName;
        }
        if (propertyList.size() == 2) {
            Iterator<IntegerObjectPropertyExpression> it = propertyList.iterator();
            Integer first = this.getObjectPropertyId(it.next());
            Integer second = this.getObjectPropertyId(it.next());
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRI3Axiom(first, second, superProperty, propertyAxiom.getAnnotations()));
        } else if (propertyList.size() == 1) {
            Integer subProperty = this.getObjectPropertyId(propertyList.iterator().next());
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRI2Axiom(subProperty, superProperty, propertyAxiom.getAnnotations()));
        } else if (propertyList.size() == 0) {
            ret.add(this.getOntologyObjectFactory().getNormalizedAxiomFactory().createRI1Axiom(superProperty, propertyAxiom.getAnnotations()));
        }
        return ret;
    }

    private Integer getObjectPropertyId(IntegerObjectPropertyExpression propExpr) {
        return propExpr.accept(new ObjectPropertyIdFinder(this.getOntologyObjectFactory().getEntityManager()));
    }

    private IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.ontologyObjectFactory;
    }
}

