/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerEntityManager;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectInverseOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectProperty;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpressionVisitor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ObjectPropertyIdFinder
implements IntegerObjectPropertyExpressionVisitor<Integer> {
    private final IntegerEntityManager idGenerator;
    private final Set<NormalizedIntegerAxiom> requiredAxioms = new HashSet<NormalizedIntegerAxiom>();

    public ObjectPropertyIdFinder(IntegerEntityManager manager) {
        Objects.requireNonNull(manager);
        this.idGenerator = manager;
    }

    public IntegerEntityManager getIdGenerator() {
        return this.idGenerator;
    }

    public Set<NormalizedIntegerAxiom> getRequiredAxioms() {
        return Collections.unmodifiableSet(this.requiredAxioms);
    }

    @Override
    public Integer visit(IntegerObjectInverseOf objectPropertyExpression) {
        Objects.requireNonNull(objectPropertyExpression);
        Integer firstProperty = objectPropertyExpression.getInverse().getId();
        Integer secondProperty = this.getIdGenerator().createOrGetInverseObjectPropertyOf(firstProperty);
        return secondProperty;
    }

    @Override
    public Integer visit(IntegerObjectProperty objectPropertyExpression) {
        Objects.requireNonNull(objectPropertyExpression);
        return objectPropertyExpression.getId();
    }
}

