/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.ontology.normalization;

import de.tudresden.inf.lat.jcel.coreontology.axiom.NormalizedIntegerAxiom;
import de.tudresden.inf.lat.jcel.coreontology.datatype.IntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.complex.IntegerInverseObjectPropertiesAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.normalization.SimpleNormalizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class OntologyNormalizer {
    public Set<NormalizedIntegerAxiom> normalize(Set<ComplexIntegerAxiom> originalAxiomSet, IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(originalAxiomSet);
        Objects.requireNonNull(factory);
        HashSet<NormalizedIntegerAxiom> ret = new HashSet<NormalizedIntegerAxiom>();
        SimpleNormalizer normalizer = new SimpleNormalizer(factory);
        HashSet<Integer> objectPropIdSet = new HashSet<Integer>();
        HashSet<IntegerAxiom> currentAxiomSet = new HashSet<IntegerAxiom>();
        for (ComplexIntegerAxiom axiom : originalAxiomSet) {
            objectPropIdSet.addAll(axiom.getObjectPropertiesInSignature());
            if (axiom instanceof IntegerInverseObjectPropertiesAxiom) {
                Set<IntegerAxiom> newSet = normalizer.normalize(axiom);
                currentAxiomSet.addAll(newSet);
                continue;
            }
            currentAxiomSet.add(axiom);
        }
        for (Integer propId : objectPropIdSet) {
            Integer inversePropId = factory.getEntityManager().createOrGetInverseObjectPropertyOf(propId);
            currentAxiomSet.addAll(normalizer.getAxiomsForInverseObjectProperties(propId, inversePropId));
        }
        while (currentAxiomSet.size() > 0) {
            HashSet<IntegerAxiom> nextAxiomSet = new HashSet<IntegerAxiom>();
            for (IntegerAxiom axiom : currentAxiomSet) {
                if (axiom instanceof NormalizedIntegerAxiom) {
                    ret.add((NormalizedIntegerAxiom)axiom);
                    continue;
                }
                Set<IntegerAxiom> newSet = normalizer.normalize(axiom);
                nextAxiomSet.addAll(newSet);
            }
            currentAxiomSet = nextAxiomSet;
        }
        return Collections.unmodifiableSet(ret);
    }
}

