/*
 * Decompiled with CFR 0.152.
 */
package slib.utils;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    static Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static List<File> listFilesForFolder(String folder, List<String> admittedExtensions, Integer fileLimit) {
        logger.info("List files from folder: " + folder);
        logger.info("extensions: " + admittedExtensions);
        logger.info("Limits: " + fileLimit);
        List<File> files = FileUtils.listFilesForFolderInner(new File(folder), admittedExtensions, new ArrayList<File>(), fileLimit);
        logger.info(files.size() + " files have been found");
        return files;
    }

    public static List<File> listFilesForFolder(String folder, List<String> admittedExtensions) {
        logger.info("List files from folder: " + folder);
        logger.info("extensions: " + admittedExtensions);
        List<File> files = FileUtils.listFilesForFolderInner(new File(folder), admittedExtensions, new ArrayList<File>(), null);
        logger.info(files.size() + " files have been found");
        return files;
    }

    private static List<File> listFilesForFolderInner(File folder, List<String> admittedExtensions, List<File> files, Integer fileLimit) {
        for (File fileEntry : folder.listFiles()) {
            if (fileLimit != null && files.size() >= fileLimit) {
                return files;
            }
            if (fileEntry.isDirectory()) {
                FileUtils.listFilesForFolderInner(fileEntry, admittedExtensions, files, fileLimit);
                continue;
            }
            if (admittedExtensions != null && !admittedExtensions.contains(FilenameUtils.getExtension((String)fileEntry.getPath()))) continue;
            files.add(fileEntry);
        }
        return files;
    }

    public static String readFile(String path, Charset encoding) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        return new String(encoded, encoding);
    }
}

