/*
 * Decompiled with CFR 0.152.
 */
package slib.utils.impl;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.utils.impl.IO_RuntimeException;
import slib.utils.impl.QueryEntry;
import slib.utils.impl.QueryIterator;

public class QueryFileIterator
implements QueryIterator {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    BufferedReader br;
    DataInputStream in;
    String filepath;
    String line;
    final String uriPrefix;

    public QueryFileIterator(String filepath) throws IOException {
        this(filepath, null);
    }

    public QueryFileIterator(String filepath, String uriPrefix) throws IOException {
        this.logger.info("Loading Query file iterator: " + filepath);
        this.logger.info("prefix (query file iterator): " + uriPrefix);
        this.filepath = filepath;
        this.uriPrefix = uriPrefix;
        FileInputStream fstream = new FileInputStream(filepath);
        this.in = new DataInputStream(fstream);
        this.br = new BufferedReader(new InputStreamReader(this.in));
        this.line = this.br.readLine();
    }

    @Override
    public boolean hasNext() {
        if (this.line == null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                throw new IO_RuntimeException("Error reading file " + this.filepath + " original " + e.getMessage());
            }
        }
        return this.line != null;
    }

    @Override
    public QueryEntry next() {
        QueryEntry entry = null;
        try {
            String[] csvRow = this.line.split("\t");
            if (csvRow.length == 2) {
                entry = this.uriPrefix != null ? new QueryEntry(this.uriPrefix + csvRow[0], this.uriPrefix + csvRow[1]) : new QueryEntry(csvRow[0], csvRow[1]);
            }
            this.line = this.br.readLine();
        }
        catch (IOException e) {
            throw new IO_RuntimeException("Error reading file " + this.filepath + " original " + e.getMessage());
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        if (this.br != null) {
            this.br.close();
        }
    }

    @Override
    public List<QueryEntry> nextValids(int nbValues) {
        ArrayList<QueryEntry> bench = new ArrayList<QueryEntry>();
        int c = 0;
        while (c < nbValues && this.hasNext()) {
            QueryEntry e = this.next();
            if (e == null || !e.isValid()) continue;
            bench.add(e);
            ++c;
        }
        return bench;
    }

    @Override
    public long getNumberQueries() throws Exception {
        LineNumberReader lnr = new LineNumberReader(new FileReader(new File(this.filepath)));
        lnr.skip(Long.MAX_VALUE);
        return lnr.getLineNumber() + 1;
    }
}

