/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.traversal.classical;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.traversal.GraphTraversal;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.utils.impl.SetUtils;

public class DFS
implements GraphTraversal {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    G g;
    Set<URI> sources;
    HashMap<URI, Boolean> coloredVertex;
    private WalkConstraint wc;
    List<URI> topoSort;
    int current_id = 0;
    boolean removePerformed = false;

    public DFS(G g, Set<URI> sources, WalkConstraint wc) {
        this.g = g;
        this.sources = sources;
        this.wc = wc;
        this.init();
    }

    public DFS(G g, URI source, WalkConstraint wc) {
        this(g, SetUtils.buildSet((Object)source), wc);
    }

    private void init() {
        this.coloredVertex = new HashMap();
        this.topoSort = new ArrayList<URI>();
        this.logger.debug("Iterator loaded for " + this.g.getURI() + " from " + this.sources.size() + " source(s) " + this.sources);
        this.logger.debug("Considering Walkconstraint " + this.wc);
        this.logger.debug("Start DFS");
        for (URI r : this.sources) {
            this.performDFS(r);
        }
        this.current_id = this.topoSort.size() - 1;
        this.logger.debug("TopoSort contains " + this.topoSort.size() + " vertices (on " + this.g.getNumberVertices() + " graph vertices)");
    }

    private void performDFS(URI v) {
        if (!this.coloredVertex.containsKey(v)) {
            this.coloredVertex.put(v, true);
            for (E e : this.g.getE(v, this.wc)) {
                if (!e.getTarget().equals((Object)v)) {
                    this.performDFS(e.getTarget());
                    continue;
                }
                this.performDFS(e.getSource());
            }
            this.topoSort.add(v);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current_id > 0;
    }

    @Override
    public URI next() {
        this.removePerformed = false;
        --this.current_id;
        return this.topoSort.get(this.current_id + 1);
    }

    public List<URI> getTraversalOrder() {
        return this.topoSort;
    }
}

