/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.extraction.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.accessor.GraphAccessor;
import slib.graph.algo.extraction.rvf.DescendantEngine;
import slib.graph.algo.extraction.rvf.RVF_TAX;
import slib.graph.algo.extraction.utils.GAction;
import slib.graph.algo.extraction.utils.GActionType;
import slib.graph.algo.extraction.utils.RooterDAG;
import slib.graph.algo.reduction.dag.GraphReduction_Transitive;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;

public class GraphActionExecutor {
    static Logger logger = LoggerFactory.getLogger(GraphActionExecutor.class);
    public static final String REROOT_UNIVERSAL_ROOT_FLAG = "__FICTIVE__";

    public static void applyAction(GAction action, G g) throws SLIB_Ex_Critic {
        GraphActionExecutor.applyAction((URIFactory)URIFactoryMemory.getSingleton(), action, g);
    }

    public static void applyAction(URIFactory factory, GAction action, G g) throws SLIB_Ex_Critic {
        GActionType actionType = action.type;
        if (actionType == GActionType.TRANSITIVE_REDUCTION) {
            GraphActionExecutor.transitive_reduction(action, g);
        } else if (actionType == GActionType.REROOTING) {
            GraphActionExecutor.rerooting(factory, action, g);
        } else if (actionType == GActionType.VERTICES_REDUCTION) {
            GraphActionExecutor.verticeReduction(factory, action, g);
        } else if (actionType == GActionType.PREDICATE_SUBSTITUTE) {
            GraphActionExecutor.predicateSubstitution(factory, action, g);
        } else {
            throw new SLIB_Ex_Critic("Unknow action " + (Object)((Object)action.type));
        }
    }

    private static void verticeReduction(URIFactory factory, GAction action, G g) throws SLIB_Ex_Critic {
        logger.info("-------------------------------------");
        logger.info(" Vertices Reduction");
        logger.info("-------------------------------------");
        logger.info("Starting " + (Object)((Object)GActionType.VERTICES_REDUCTION));
        String regex = (String)action.getParameter("regex");
        String vocVal = (String)action.getParameter("vocabulary");
        String file_uris = (String)action.getParameter("file_uris");
        String rootURIs = (String)action.getParameter("root_uri");
        Set<URI> classes = GraphAccessor.getClasses(g);
        Set<URI> instances = GraphAccessor.getInstances(g);
        logger.info("Classes  : " + classes.size());
        logger.info("instances: " + instances.size());
        logger.info("vertices : " + g.getV().size());
        HashSet<URI> toRemove = new HashSet<URI>();
        if (rootURIs != null) {
            logger.info("Applying reduction of the part of the graph " + g.getURI() + " which is not contained in the graph induced by " + rootURIs + " (only the classes subsumed by the given root are considered)");
            try {
                URI rootURI = factory.getURI(rootURIs);
                if (!g.containsVertex(rootURI)) {
                    throw new SLIB_Ex_Critic("Error cannot state vertex associated to URI " + rootURI + " in graph " + g.getURI());
                }
                DescendantEngine descEngine = new DescendantEngine(g);
                Set<URI> descsInclusive = descEngine.getDescendantsInc(rootURI);
                logger.info(descsInclusive.size() + " subclasses of " + rootURI + " detected");
                int classesNb = classes.size();
                Set<URI> classesToRemove = classes;
                classesToRemove.removeAll(descsInclusive);
                logger.info("Removing " + classesToRemove.size() + "/" + classesNb + " classes of the graph");
                g.removeV(classesToRemove);
                HashSet<URI> instancesToRemove = new HashSet<URI>();
                for (URI v : instances) {
                    if (descsInclusive.contains(v) || !g.getV(v, RDF.TYPE, Direction.OUT).isEmpty()) continue;
                    instancesToRemove.add(v);
                }
                logger.info("Removing " + instancesToRemove.size() + " instances of the graph");
                g.removeV(instancesToRemove);
            }
            catch (IllegalArgumentException e) {
                throw new SLIB_Ex_Critic("Error value specified for parameter root_uri, i.e. " + rootURIs + " cannot be converted into an URI");
            }
        }
        if (regex != null) {
            Pattern pattern;
            logger.info("Applying regex: " + regex);
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new SLIB_Ex_Critic("The specified regex '" + regex + "' is invalid: " + e.getMessage());
            }
            for (URI v : g.getV()) {
                Matcher matcher = pattern.matcher(v.stringValue());
                if (!matcher.find()) continue;
                toRemove.add(v);
                logger.debug("regex matches: " + v);
            }
            logger.info("Vertices to remove: " + toRemove.size() + "/" + g.getV().size());
            g.removeV(toRemove);
            logger.debug("ending " + (Object)((Object)GActionType.VERTICES_REDUCTION));
        } else if (vocVal != null) {
            String[] vocs;
            for (String voc : vocs = vocVal.split(",")) {
                if (voc.trim().equals("RDF")) {
                    logger.info("Removing RDF vocabulary");
                    GraphActionExecutor.removeVocURIs(factory, GraphActionExecutor.getRDFVocURIs(), g);
                    continue;
                }
                if (voc.trim().equals("RDFS")) {
                    logger.info("Removing RDFS vocabulary");
                    GraphActionExecutor.removeVocURIs(factory, GraphActionExecutor.getRDFSVocURIs(), g);
                    continue;
                }
                if (!voc.trim().equals("OWL")) continue;
                logger.info("Removing OWL vocabulary");
                GraphActionExecutor.removeVocURIs(factory, GraphActionExecutor.getOWLVocURIs(), g);
            }
        } else if (file_uris != null) {
            String[] files;
            for (String f : files = file_uris.split(",")) {
                logger.info("Removing Uris specified in " + f);
                try {
                    String line;
                    FileInputStream fstream = new FileInputStream(f.trim());
                    DataInputStream in = new DataInputStream(fstream);
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null) {
                        line = line.trim();
                        g.removeV(factory.getURI(line));
                    }
                    in.close();
                }
                catch (IOException e) {
                    throw new SLIB_Ex_Critic(e.getMessage());
                }
            }
        }
        logger.info("vertices reduction performed");
        logger.info("-------------------------------------");
    }

    private static String[] getRDFVocURIs() {
        return new String[]{"http://www.w3.org/1999/02/22-rdf-syntax-ns#first", "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil", "http://www.w3.org/1999/02/22-rdf-syntax-ns#predicate", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Alt", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Seq", "http://www.w3.org/1999/02/22-rdf-syntax-ns#type", "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest", "http://www.w3.org/1999/02/22-rdf-syntax-ns#value", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Bag", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Property", "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", "http://www.w3.org/1999/02/22-rdf-syntax-ns#object", "http://www.w3.org/1999/02/22-rdf-syntax-ns#List", "http://www.w3.org/1999/02/22-rdf-syntax-ns#Statement", "http://www.w3.org/1999/02/22-rdf-syntax-ns#subject", "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString", "http://www.w3.org/1999/02/22-rdf-syntax-ns#li"};
    }

    private static String[] getRDFSVocURIs() {
        return new String[]{"http://www.w3.org/2000/01/rdf-schema#subClassOf", "http://www.w3.org/2000/01/rdf-schema#label", "http://www.w3.org/2000/01/rdf-schema#Class", "http://www.w3.org/2000/01/rdf-schema#member", "http://www.w3.org/2000/01/rdf-schema#comment", "http://www.w3.org/2000/01/rdf-schema#Literal", "http://www.w3.org/2000/01/rdf-schema#seeAlso", "http://www.w3.org/2000/01/rdf-schema#Resource", "http://www.w3.org/2000/01/rdf-schema#Container", "http://www.w3.org/2000/01/rdf-schema#isDefinedBy", "http://www.w3.org/2000/01/rdf-schema#domain", "http://www.w3.org/2000/01/rdf-schema#subPropertyOf", "http://www.w3.org/2000/01/rdf-schema#Datatype", "http://www.w3.org/2000/01/rdf-schema#range", "http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty"};
    }

    private static String[] getOWLVocURIs() {
        return new String[]{"http://www.w3.org/2002/07/owl#AllDifferent", "http://www.w3.org/2002/07/owl#allValuesFrom", "http://www.w3.org/2002/07/owl#AnnotationProperty", "http://www.w3.org/2002/07/owl#backwardCompatibleWith", "http://www.w3.org/2002/07/owl#cardinality", "http://www.w3.org/2002/07/owl#Class", "http://www.w3.org/2002/07/owl#complementOf", "http://www.w3.org/2002/07/owl#DatatypeProperty", "http://www.w3.org/2002/07/owl#DeprecatedClass", "http://www.w3.org/2002/07/owl#DeprecatedProperty", "http://www.w3.org/2002/07/owl#differentFrom", "http://www.w3.org/2002/07/owl#disjointWith", "http://www.w3.org/2002/07/owl#distinctMembers", "http://www.w3.org/2002/07/owl#equivalentClass", "http://www.w3.org/2002/07/owl#equivalentProperty", "http://www.w3.org/2002/07/owl#FunctionalProperty", "http://www.w3.org/2002/07/owl#hasValue", "http://www.w3.org/2002/07/owl#imports", "http://www.w3.org/2002/07/owl#incompatibleWith", "http://www.w3.org/2002/07/owl#Individual", "http://www.w3.org/2002/07/owl#intersectionOf", "http://www.w3.org/2002/07/owl#InverseFunctionalProperty", "http://www.w3.org/2002/07/owl#inverseOf", "http://www.w3.org/2002/07/owl#maxCardinality", "http://www.w3.org/2002/07/owl#minCardinality", "http://www.w3.org/2002/07/owl#ObjectProperty", "http://www.w3.org/2002/07/owl#oneOf", "http://www.w3.org/2002/07/owl#onProperty", "http://www.w3.org/2002/07/owl#Ontology", "http://www.w3.org/2002/07/owl#OntologyProperty", "http://www.w3.org/2002/07/owl#priorVersion", "http://www.w3.org/2002/07/owl#Restriction", "http://www.w3.org/2002/07/owl#sameAs", "http://www.w3.org/2002/07/owl#someValuesFrom", "http://www.w3.org/2002/07/owl#SymmetricProperty", "http://www.w3.org/2002/07/owl#TransitiveProperty", "http://www.w3.org/2002/07/owl#unionOf", "http://www.w3.org/2002/07/owl#versionInfo"};
    }

    private static void removeVocURIs(URIFactory factory, String[] toRemove, G g) {
        for (String s : toRemove) {
            g.removeV(factory.getURI(s));
        }
    }

    private static void rerooting(URIFactory factory, GAction action, G g) throws SLIB_Ex_Critic {
        URI rootURI;
        logger.info("-------------------------------------");
        logger.info("Rerooting");
        logger.info("-------------------------------------");
        String rootURIstring = (String)action.getParameter("root_uri");
        logger.info("Fetching root node, uri: " + rootURIstring);
        if (rootURIstring == null || rootURIstring.equals(REROOT_UNIVERSAL_ROOT_FLAG)) {
            rootURI = OWL.THING;
            g.addV(rootURI);
            logger.info("No root node explicitly specified using 'root_uri' parameter. Set root : " + rootURI);
        } else {
            rootURI = factory.getURI(rootURIstring);
            if (!g.containsVertex(rootURI)) {
                logger.info("Create class " + rootURI);
                g.addV(rootURI);
            }
        }
        RooterDAG.rootUnderlyingTaxonomicDAG(g, rootURI);
        logger.info("Rerooting performed");
        logger.info("-------------------------------------");
    }

    private static void transitive_reduction(GAction action, G g) throws SLIB_Ex_Critic {
        logger.info("-------------------------------------");
        logger.info("Transitive Reduction");
        logger.info("-------------------------------------");
        Object[] targets = !action.existsParam("target") ? new String[]{"RDFS:SUBCLASSOF"} : ((String)action.getParameter("target")).split(",");
        logger.info("Targets: " + Arrays.toString(targets));
        String[] admittedTarget_CLASSES = new String[]{"CLASSES", "RDFS:SUBCLASSOF", "RDFS.SUBCLASSOF"};
        String[] admittedTarget_INSTANCES = new String[]{"INSTANCES", "RDF:TYPE", "RDF.TYPE"};
        for (Object target : targets) {
            if (Arrays.asList(admittedTarget_CLASSES).contains(((String)target).trim().toUpperCase())) {
                GraphReduction_Transitive.process(g);
                continue;
            }
            if (Arrays.asList(admittedTarget_INSTANCES).contains(((String)target).trim().toUpperCase())) {
                GraphActionExecutor.transitive_reductionInstance(action, g);
                continue;
            }
            throw new SLIB_Ex_Critic("Unknow target '" + (String)target + "', please precise a valid 'target' parameter', accepted values (in lower or upper case) " + Arrays.asList(admittedTarget_CLASSES) + " or " + Arrays.asList(admittedTarget_INSTANCES));
        }
        logger.info("Transitive reduction performed");
        logger.info("-------------------------------------");
    }

    private static void transitive_reductionInstance(GAction action, G g) throws SLIB_Ex_Critic {
        int invalidInstanceNb = 0;
        int annotNbBase = 0;
        int annotDeleted = 0;
        Set<URI> instances = GraphAccessor.getInstances(g);
        logger.info("Cleaning " + RDF.TYPE + " triplets of " + g.getURI());
        System.out.println(g);
        RVF_TAX rvf = new RVF_TAX(g, Direction.IN);
        Map<URI, Set<URI>> descs = rvf.getAllRVClass();
        for (URI instance : instances) {
            HashSet<URI> redundants = new HashSet<URI>();
            Set classes = g.getV(instance, RDF.TYPE, Direction.OUT);
            annotNbBase += classes.size();
            Iterator it = classes.iterator();
            block1: while (it.hasNext()) {
                URI c = (URI)it.next();
                Set<URI> descC = descs.get(c);
                for (URI c2 : classes) {
                    if (c == c2 || !descC.contains(c2)) continue;
                    redundants.add(c);
                    it.remove();
                    continue block1;
                }
            }
            if (redundants.isEmpty()) continue;
            for (URI r : redundants) {
                g.removeE((E)new Edge(instance, RDF.TYPE, r));
            }
            ++invalidInstanceNb;
            annotDeleted += redundants.size();
        }
        double invalidInstanceP = 0.0;
        if (instances.size() > 0) {
            invalidInstanceP = invalidInstanceNb * 100 / instances.size();
        }
        double annotDelP = 0.0;
        if (annotNbBase > 0) {
            annotDelP = annotDeleted * 100 / annotNbBase;
        }
        logger.info("Number of instance containing abnormal annotation: " + invalidInstanceNb + "/" + instances.size() + "  i.e. (" + invalidInstanceP + "%)");
        logger.info("Number of annotations: " + annotNbBase + ", deleted: " + annotDeleted + " (" + annotDelP + "%), current annotation number " + (annotNbBase - annotDeleted));
    }

    public static void applyActions(URIFactory factory, List<GAction> actions, G g) throws SLIB_Ex_Critic {
        logger.info("-------------------------------------");
        logger.info(" Applying actions");
        logger.info("-------------------------------------");
        for (GAction action : actions) {
            GraphActionExecutor.applyAction(factory, action, g);
        }
        logger.info("Actions performed");
        logger.info("-------------------------------------");
    }

    private static void predicateSubstitution(URIFactory factory, GAction action, G g) throws SLIB_Ex_Critic {
        logger.info("-------------------------------------");
        logger.info(" Predicate Substitution");
        logger.info("-------------------------------------");
        logger.info("Starting " + (Object)((Object)GActionType.PREDICATE_SUBSTITUTE));
        String old_URI = (String)action.getParameter("old_uri");
        String new_URI = (String)action.getParameter("new_uri");
        if (old_URI == null || new_URI == null) {
            throw new SLIB_Ex_Critic("Error - please specify a parameter old_uri and new_uri");
        }
        if (old_URI.toUpperCase().equals("RDFS.SUBCLASSOF")) {
            old_URI = RDFS.SUBCLASSOF.toString();
        }
        if (new_URI.toUpperCase().equals("RDFS.SUBCLASSOF")) {
            new_URI = RDFS.SUBCLASSOF.toString();
        }
        URI oldURI = factory.getURI(old_URI);
        URI newURI = factory.getURI(new_URI);
        Set oldRel = g.getE(oldURI);
        g.removeE(oldRel);
        for (E e : oldRel) {
            g.addE(e.getSource(), newURI, e.getTarget());
        }
        logger.info(oldRel.size() + " relations modified");
    }
}

