/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.reduction.dag;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.accessor.GraphAccessor;
import slib.graph.algo.traversal.classical.DFS;
import slib.graph.algo.validator.dag.ValidatorDAG;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Ex_Warning;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class GraphReduction_DAG_Ranwez_2011 {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    G graph;
    G graph_reduction;
    Set<URI> selectedURIs;
    Set<URI> verticesRed;
    List<URI> traversalOrder;
    Set<URI> predicatesTC;
    private Set<URI> predicatesToAdd;

    public GraphReduction_DAG_Ranwez_2011(G graph) throws SLIB_Exception {
        this(graph, SetUtils.buildSet((Object)RDFS.SUBCLASSOF), SetUtils.buildSet((Object)RDFS.SUBCLASSOF), true);
    }

    public GraphReduction_DAG_Ranwez_2011(G graph, Set<URI> predicatesTC, Set<URI> predicateToAdd, boolean validateDAGproperty) throws SLIB_Exception {
        this.graph = graph;
        this.predicatesTC = predicatesTC;
        this.predicatesToAdd = predicateToAdd;
        this.logger.debug("Selected predicate(s): " + predicatesTC);
        this.logger.debug("Predicate to add (post Treatment): " + predicateToAdd);
        if (validateDAGproperty) {
            this.checkGraphProperties();
        }
    }

    public void exec(Set<URI> selectedURIs, G g_reduction) throws SLIB_Ex_Critic, SLIB_Ex_Warning {
        Set types;
        this.logger.debug("###########################################################################");
        this.logger.debug(selectedURIs.toString());
        this.graph_reduction = g_reduction;
        this.selectedURIs = selectedURIs;
        this.verticesRed = new HashSet<URI>();
        this.logger.debug("Query composed of  " + selectedURIs.size() + " elements");
        this.logger.debug("Edges types   " + this.predicatesTC.size() + " elements");
        this.checkQueryValidity();
        this.computeTraversalRestriction();
        for (URI type : this.predicatesTC) {
            types = SetUtils.buildSet((Object)type);
            this.verticesRed.addAll(this.reduce(this.traversalOrder, types, Direction.OUT));
            this.logger.debug("Reduction: " + this.verticesRed);
            this.logger.debug("Reduction Vertices : " + this.verticesRed.size());
        }
        Collections.reverse(this.traversalOrder);
        for (URI type : this.predicatesTC) {
            types = SetUtils.buildSet((Object)type);
            this.verticesRed.addAll(this.reduce(this.traversalOrder, types, Direction.IN));
            this.logger.debug("Reduction: " + this.verticesRed);
            this.logger.debug("Reduction Vertices : " + this.verticesRed.size());
        }
        double vReductionP = 100 - this.verticesRed.size() * 100 / this.graph.getV().size();
        this.logger.debug("Reduction Vertices : " + this.verticesRed.size() + " ( ~" + vReductionP + "% of " + this.graph.getURI() + ")");
        this.logger.debug("Reduction : " + this.verticesRed);
        this.graph_reduction.addV(this.verticesRed);
        Collections.reverse(this.traversalOrder);
        this.logger.debug(this.traversalOrder.toString());
        for (URI e : this.predicatesTC) {
            this.addEdges(this.traversalOrder, e);
        }
        this.logger.debug("Adding direct edges considering " + this.predicatesToAdd);
        this.logger.debug("Adding direct edges considering " + this.predicatesToAdd.size() + " eType(s)");
        this.logger.debug("" + this.predicatesToAdd);
        for (URI v : this.verticesRed) {
            Set edgesV = this.graph.getE(v, Direction.BOTH);
            for (E e : edgesV) {
                if (!this.verticesRed.contains(e.getSource()) || !this.verticesRed.contains(e.getTarget()) || !this.predicatesToAdd.contains(e.getURI())) continue;
                this.graph_reduction.addE(e);
            }
        }
        double eReductionP = 100 - this.graph_reduction.getE().size() * 100 / this.graph.getE().size();
        this.logger.debug("Reduction Edges \t : " + this.verticesRed.size() + " ( ~" + eReductionP + "% of " + this.graph.getURI() + ")");
        this.logger.info("Reduction performed");
    }

    private void computeTraversalRestriction() throws SLIB_Ex_Critic {
        WalkConstraintGeneric wc = new WalkConstraintGeneric();
        for (URI edgesType : this.predicatesTC) {
            wc.addAcceptedTraversal(edgesType, Direction.IN);
        }
        HashSet<URI> roots = new HashSet<URI>();
        for (URI uri : GraphAccessor.getClasses(this.graph)) {
            boolean valid = true;
            for (URI p : this.predicatesTC) {
                if (this.graph.getE(p, uri, Direction.OUT).isEmpty()) continue;
                valid = false;
            }
            if (!valid) continue;
            roots.add(uri);
        }
        if (roots.isEmpty()) {
            throw new SLIB_Ex_Critic("Cannot identify any root...");
        }
        DFS dfs = new DFS(this.graph, roots, (WalkConstraint)wc);
        this.traversalOrder = dfs.getTraversalOrder();
    }

    private void addEdges(List<URI> traversalOrder, URI edgeType) {
        this.logger.debug("-------------------------------------------------");
        this.logger.debug("-------------------------------------------------");
        this.logger.debug("Adding Edges of transitive type : " + edgeType);
        this.logger.debug("verticesRed : " + this.verticesRed);
        this.logger.debug("Starting from  : " + traversalOrder.get(0));
        HashMap<URI, Set> vrra = new HashMap<URI, Set>();
        for (int i = 0; i < traversalOrder.size(); ++i) {
            URI u = traversalOrder.get(i);
            if (!vrra.containsKey(u)) {
                vrra.put(u, new HashSet());
            }
            if (this.verticesRed.contains(u)) {
                for (URI r : (Collection)vrra.get(u)) {
                    URI source = u;
                    URI target = r;
                    this.graph_reduction.addE(target, edgeType, source);
                }
                vrra.put(u, new HashSet());
                ((Collection)vrra.get(u)).add(u);
            }
            Set edges = this.graph.getE(edgeType, u, Direction.OUT);
            for (E e : edges) {
                URI f = e.getTarget();
                if (!vrra.containsKey(f)) {
                    vrra.put(f, new HashSet());
                }
                vrra.put(f, SetUtils.union((Collection)((Collection)vrra.get(u)), (Collection)((Collection)vrra.get(f))));
                if (!this.verticesRed.contains(u)) continue;
                ((Collection)vrra.get(f)).add(u);
            }
        }
    }

    private Set<URI> reduce(List<URI> order, Set<URI> edgeTypes, Direction dir) {
        this.logger.debug("-----------------------------------------------------------");
        this.logger.debug("'Transitive Closure' considering EdgeTypes : " + edgeTypes);
        this.logger.debug("Direction: " + dir);
        this.logger.debug("Propogation started from : " + order.get(0));
        this.logger.debug("Size traversal ordering: " + order.size());
        HashMap sd = new HashMap(order.size());
        HashMap<URI, Integer> maxSd = new HashMap<URI, Integer>();
        HashSet<URI> verticesReduction = new HashSet<URI>();
        for (URI v : order) {
            sd.put(v, new HashSet());
            maxSd.put(v, 0);
        }
        for (URI v : order) {
            if (this.selectedURIs.contains(v)) {
                ((Set)sd.get(v)).add(v);
            }
            if (((Set)sd.get(v)).size() > (Integer)maxSd.get(v)) {
                verticesReduction.add(v);
                ((Set)sd.get(v)).add(v);
            }
            for (E e : this.graph.getE(edgeTypes, v, dir)) {
                URI t = dir == Direction.OUT ? e.getTarget() : e.getSource();
                if (!sd.containsKey(t)) continue;
                HashSet union = new HashSet(SetUtils.union((Collection)((Collection)sd.get(t)), (Collection)((Collection)sd.get(v))));
                sd.put(t, union);
                maxSd.put(t, Math.max(((Set)sd.get(v)).size(), (Integer)maxSd.get(t)));
            }
        }
        this.logger.debug(" " + ((Object)verticesReduction).toString());
        this.logger.debug("-reduction contains " + verticesReduction.size());
        return verticesReduction;
    }

    private void checkQueryValidity() throws SLIB_Ex_Critic, SLIB_Ex_Warning {
        if (this.selectedURIs == null || this.selectedURIs.size() < 2) {
            throw new SLIB_Ex_Warning("Warning: Query skipped, a minimim of two URI have to be specified to build a query");
        }
        for (URI uri : this.selectedURIs) {
            if (this.graph.containsVertex(uri)) continue;
            throw new SLIB_Ex_Warning("No vertex associated to URI: " + uri);
        }
    }

    private void checkGraphProperties() throws SLIB_Ex_Critic {
        this.logger.debug("Checking DAG property");
        ValidatorDAG vdag = new ValidatorDAG();
        WalkConstraintGeneric wc = new WalkConstraintGeneric();
        for (URI edgeType : this.predicatesTC) {
            wc.addAcceptedTraversal(edgeType, Direction.IN);
        }
        boolean isDag = vdag.isDag(this.graph, (WalkConstraint)wc);
        this.logger.debug("is DAG: " + isDag);
        if (!isDag) {
            throw new SLIB_Ex_Critic("Treatment can only be performed on a DAG, traversal respecting your parameters define a cyclic graph.");
        }
    }
}

