/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.validator.dag;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.accessor.GraphAccessor;
import slib.graph.algo.utils.Color;
import slib.graph.algo.validator.dag.Path;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.utils.WalkConstraintGeneric;
import slib.graph.utils.WalkConstraintUtils;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.impl.SetUtils;

public class ValidatorDAG {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    G graph;
    WalkConstraint wc;
    HashMap<URI, Color> verticesColors;
    boolean valid;
    E lastEdge;
    Path currentPath;

    public boolean isDag(G graph, Set<URI> startingURIs, WalkConstraint wc) throws SLIB_Ex_Critic {
        this.wc = wc;
        this.graph = graph;
        this.verticesColors = new HashMap();
        this.valid = true;
        this.logger.debug("Cheking DAG property of : " + graph.getURI());
        this.logger.debug("WalkConstraint                  : " + wc);
        if (startingURIs == null || startingURIs.isEmpty()) {
            return false;
        }
        this.logger.debug("starting nodes          : " + startingURIs.size());
        if (startingURIs.size() < 10) {
            this.logger.debug("starting vertices : " + startingURIs);
        }
        this.currentPath = new Path();
        for (URI rootUri : startingURIs) {
            if (!graph.containsVertex(rootUri)) {
                throw new SLIB_Ex_Critic("Vertex '" + rootUri + "' not found in " + graph.getURI());
            }
            if (!this.valid) continue;
            this.performDFS(rootUri);
        }
        this.logger.info("isDag : " + this.valid);
        if (!this.valid) {
            this.logger.info("current path :" + this.currentPath.toString());
            this.logger.info("Cycle detected adding : " + this.lastEdge + " to path");
        }
        return this.valid;
    }

    private void performDFS(URI v) {
        if (!this.valid) {
            return;
        }
        if (!this.verticesColors.containsKey(v)) {
            this.verticesColors.put(v, Color.ORANGE);
            Set edges = this.graph.getE(v, this.wc);
            for (E e : edges) {
                if (!this.valid) {
                    return;
                }
                URI target = e.getTarget();
                if (target.equals((Object)v)) {
                    target = e.getSource();
                }
                if (this.verticesColors.get(target) == Color.RED) continue;
                this.currentPath.addEdge(e);
                this.lastEdge = e;
                this.performDFS(target);
            }
            if (!this.valid) {
                return;
            }
            this.currentPath.removeLastEdge();
            this.verticesColors.put(v, Color.RED);
        } else if (this.verticesColors.get(v) == Color.ORANGE) {
            this.valid = false;
        }
    }

    public boolean isDag(G graph, URI rootURI, WalkConstraint wc) throws SLIB_Ex_Critic {
        return this.isDag(graph, SetUtils.buildSet((Object)rootURI), wc);
    }

    public boolean containsTaxonomicDag(G graph) throws SLIB_Ex_Critic {
        WalkConstraintGeneric wct = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.IN);
        return this.isDag(graph, (WalkConstraint)wct);
    }

    public boolean isDag(G graph, WalkConstraint wc) throws SLIB_Ex_Critic {
        this.logger.debug("Check DAG property of the graph " + graph.getURI() + " considering the walkconstraint " + wc);
        Set<URI> startingNodes = this.getDAGRoots(graph, WalkConstraintUtils.getInverse((WalkConstraint)wc, (boolean)false));
        this.logger.info("Starting process from " + startingNodes.size() + " vertices");
        if (graph.getE().isEmpty()) {
            this.logger.info("No edge");
        } else {
            if (startingNodes.isEmpty()) {
                this.logger.debug("No roots have been detected...");
                this.logger.debug("DAG = false");
                return false;
            }
            if (!this.isDag(graph, startingNodes, wc)) {
                return false;
            }
        }
        return true;
    }

    public Set<URI> getDAGRoots(G g, WalkConstraint wc) {
        Set<URI> classes = GraphAccessor.getClasses(g);
        HashSet<URI> roots = new HashSet<URI>();
        for (URI v : classes) {
            if (!g.getV(v, wc).isEmpty()) continue;
            roots.add(v);
        }
        return roots;
    }

    public boolean containsTaxonomicDagWithUniqueRoot(G g) throws SLIB_Ex_Critic {
        WalkConstraintGeneric wc = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.OUT);
        Set<URI> roots = this.getDAGRoots(g, (WalkConstraint)wc);
        this.logger.info("Number of roots " + roots.size());
        this.logger.debug("Root(s): " + roots);
        if (roots.size() == 1) {
            this.isDag(g, roots.iterator().next(), (WalkConstraint)new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.IN));
        } else {
            this.valid = false;
        }
        this.logger.debug("isRootedTaxonomicDag (" + roots.size() + " root(s)) valid " + this.valid);
        return this.valid;
    }

    public URI getUniqueTaxonomicRoot(G g) throws SLIB_Ex_Critic {
        WalkConstraintGeneric wcTax = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.OUT);
        Set<URI> roots = this.getDAGRoots(g, (WalkConstraint)wcTax);
        if (roots.size() != 1) {
            throw new SLIB_Ex_Critic("Multiple roots detected in the underlying taxonomic graph of graph " + g.getURI());
        }
        return roots.iterator().next();
    }

    public Set<URI> getTaxonomicRoots(G g) {
        return this.getDAGRoots(g, (WalkConstraint)new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.OUT));
    }

    public boolean containsRootedDagRoot(G g, URI rootURI, WalkConstraint wc) {
        for (URI v : this.getDAGRoots(g, wc)) {
            if (!v.equals((Object)rootURI)) continue;
            return true;
        }
        return false;
    }

    public boolean isUniqueRootedTaxonomicDag(G g, URI root) throws SLIB_Ex_Critic {
        WalkConstraintGeneric wc = new WalkConstraintGeneric(RDFS.SUBCLASSOF, Direction.IN);
        return this.isUniqueRootedDagRoot(g, root, (WalkConstraint)wc);
    }

    public boolean isUniqueRootedDagRoot(G g, URI root, WalkConstraint wc) throws SLIB_Ex_Critic {
        if (this.isDag(g, wc)) {
            Set<URI> roots = this.getDAGRoots(g, WalkConstraintUtils.getInverse((WalkConstraint)wc, (boolean)false));
            this.logger.debug("roots: " + roots);
            if (roots.size() == 1 && roots.iterator().next().equals((Object)root)) {
                return true;
            }
        }
        return false;
    }

    public E getLastEdge() {
        return this.lastEdge;
    }
}

