/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.SPARQLFederatedService;
import org.openrdf.repository.RepositoryException;

public class FederatedServiceManager {
    private static Class<? extends FederatedServiceManager> implementationClass = FederatedServiceManager.class;
    private static volatile FederatedServiceManager instance = null;
    private ConcurrentHashMap<String, FederatedService> endpointToService = new ConcurrentHashMap();

    public static FederatedServiceManager getInstance() {
        if (instance == null) {
            try {
                instance = implementationClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static synchronized void setImplementationClass(Class<? extends FederatedServiceManager> implementationClass) {
        FederatedServiceManager.implementationClass = implementationClass;
        try {
            instance = implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerService(String serviceUrl, FederatedService service) {
        this.endpointToService.put(serviceUrl, service);
    }

    public void unregisterService(String serviceUrl) {
        FederatedService service = this.endpointToService.remove(serviceUrl);
        if (service != null) {
            try {
                service.shutdown();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    public FederatedService getService(String serviceUrl) throws RepositoryException {
        FederatedService service = this.endpointToService.get(serviceUrl);
        if (service == null) {
            service = new SPARQLFederatedService(serviceUrl);
            service.initialize();
            this.endpointToService.put(serviceUrl, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        ConcurrentHashMap<String, FederatedService> concurrentHashMap = this.endpointToService;
        synchronized (concurrentHashMap) {
            for (FederatedService service : this.endpointToService.values()) {
                try {
                    service.shutdown();
                }
                catch (RepositoryException e) {}
            }
            this.endpointToService.clear();
        }
    }
}

