/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.conf;

import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.URI;
import slib.graph.algo.utils.GAction;
import slib.graph.io.conf.GDataConf;
import slib.utils.i.CheckableValidity;
import slib.utils.impl.ParametrableImpl;

public class GraphConf
extends ParametrableImpl
implements CheckableValidity,
Comparable<Object> {
    URI uri;
    List<GDataConf> data = new LinkedList<GDataConf>();
    List<GAction> actions = new LinkedList<GAction>();

    public GraphConf() {
    }

    public GraphConf(URI uri) {
        this();
        this.uri = uri;
    }

    public boolean isValid() {
        if (this.uri == null) {
            return false;
        }
        for (GDataConf dataFile : this.data) {
            if (dataFile.isValid()) continue;
            return false;
        }
        for (GAction action : this.actions) {
            if (action.isValid()) continue;
            return false;
        }
        return true;
    }

    public void addGDataConf(GDataConf conf) {
        this.data.add(conf);
    }

    public void addGAction(GAction conf) {
        this.actions.add(conf);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public List<GDataConf> getData() {
        return this.data;
    }

    public void setData(List<GDataConf> data) {
        this.data = data;
    }

    public List<GAction> getActions() {
        return this.actions;
    }

    public void setActions(List<GAction> actions) {
        this.actions = actions;
    }

    @Override
    public int compareTo(Object o) {
        return 1;
    }
}

