/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.bio.mesh;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.loader.bio.mesh.MeshConcept;
import slib.graph.io.loader.bio.mesh.MeshXMLHandler;
import slib.graph.io.util.GFormat;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.graph.memory.GraphMemory;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class GraphLoader_MESH_XML
implements GraphLoader {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Map<String, MeshConcept> idToConcepts = new HashMap<String, MeshConcept>();
    Set<MeshConcept> concepts = new HashSet<MeshConcept>();
    G graph;
    URIFactory factory = URIFactoryMemory.getSingleton();
    int conceptIgnored = 0;
    public static final String ARG_PREFIX = "prefix";
    String default_namespace;

    private String getParentId(String id) {
        String[] data = id.split("\\.");
        String idParent = null;
        for (int i = data.length - 2; i >= 0; --i) {
            idParent = idParent == null ? data[i] : data[i] + "." + idParent;
        }
        return idParent;
    }

    void addConcept(MeshConcept concept) {
        if (!concept.treeNumberList.isEmpty()) {
            for (String s : concept.treeNumberList) {
                this.idToConcepts.put(s, concept);
            }
            this.concepts.add(concept);
        } else {
            this.logger.info("Warning: no tree number associated to " + concept.descriptorUI + " concept ignored...");
            ++this.conceptIgnored;
        }
    }

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.graph = g;
        this.default_namespace = (String)conf.getParameter(ARG_PREFIX);
        if (this.default_namespace == null) {
            this.default_namespace = this.graph.getURI().getNamespace();
        }
        try {
            this.logger.info("-------------------------------------");
            this.logger.info("Loading Mesh XML");
            this.logger.info("-------------------------------------");
            this.idToConcepts = new HashMap<String, MeshConcept>();
            SAXParserFactory parserfactory = SAXParserFactory.newInstance();
            SAXParser saxParser = parserfactory.newSAXParser();
            saxParser.parse(conf.getLoc(), (DefaultHandler)new MeshXMLHandler(this));
            this.logger.info("Number of descriptor loaded " + this.concepts.size() + " (ignored " + this.conceptIgnored + ")");
            this.logger.info("Loading relationships ");
            URI universalRoot = OWL.THING;
            if (!this.graph.containsVertex(universalRoot)) {
                this.graph.addV(universalRoot);
            }
            for (Map.Entry<String, MeshConcept> e : this.idToConcepts.entrySet()) {
                MeshConcept c = e.getValue();
                URI vConcept = this.getOrCreateVertex(c.descriptorUI);
                for (String treeNumber : c.treeNumberList) {
                    String parentId = this.getParentId(treeNumber);
                    if (parentId != null) {
                        MeshConcept parent = this.idToConcepts.get(parentId);
                        if (parent == null) {
                            throw new SLIB_Ex_Critic("Cannot locate parent identified by TreeNumber " + treeNumber + "\nError occured processing\n" + c);
                        }
                        URI vParent = this.getOrCreateVertex(parent.descriptorUI);
                        Edge edge = new Edge(vConcept, RDFS.SUBCLASSOF, vParent);
                        g.addE((E)edge);
                        continue;
                    }
                    char localNameTreeRoot = treeNumber.charAt(0);
                    URI rootTree = this.getOrCreateVertex(localNameTreeRoot + "");
                    Edge treeInnerRootToTreeRoot = new Edge(vConcept, RDFS.SUBCLASSOF, rootTree);
                    g.addE((E)treeInnerRootToTreeRoot);
                    Edge treeRootToUniversalRoot = new Edge(rootTree, RDFS.SUBCLASSOF, universalRoot);
                    g.addE((E)treeRootToUniversalRoot);
                }
            }
        }
        catch (IOException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        catch (SLIB_Ex_Critic ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        this.logger.info("MESH loader - process performed");
        this.logger.info("-------------------------------------");
    }

    private URI getOrCreateVertex(String descriptorUI) {
        String uriConceptAsString = this.default_namespace + descriptorUI;
        URI uriConcept = this.factory.getURI(uriConceptAsString);
        if (!this.graph.containsVertex(uriConcept)) {
            this.graph.addV(uriConcept);
        }
        return uriConcept;
    }

    public static void main(String[] args) throws Exception {
        URIFactoryMemory factory = URIFactoryMemory.getSingleton();
        GraphMemory graph = new GraphMemory(factory.getURI("http://mesh"));
        GraphLoader_MESH_XML loader = new GraphLoader_MESH_XML();
        loader.populate(new GDataConf(GFormat.MESH_XML, "/data/mesh/desc2013.xml"), (G)graph);
        URI dna_barcoding = factory.getURI("http://D058893");
        System.out.println(graph);
        System.out.println(graph.containsVertex(dna_barcoding));
    }
}

