/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.bio.obo;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.conf.GraphConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.loader.bio.obo.utils.OboRelationship;
import slib.graph.io.loader.bio.obo.utils.OboTerm;
import slib.graph.io.loader.bio.obo.utils.OboType;
import slib.graph.model.graph.G;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Ex_Warning;
import slib.utils.ex.SLIB_Exception;

public class GraphLoader_OBO_1_2
implements GraphLoader {
    URIFactoryMemory data = URIFactoryMemory.getSingleton();
    GraphConf conf;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    boolean onTermSpec = false;
    boolean onTypeDef = false;
    G g;
    URI graphURI;
    String filepath;
    String defaultNamespace;
    final String format_parser = "1.2";
    String format_version = "undefined";
    boolean allow_all_gafVersion;
    HashMap<String, OboTerm> oboTerms;
    HashMap<String, OboType> oboTypes;
    HashMap<String, String> inverseRel;
    OboTerm oboTermCurrent = null;
    OboType oboTypeCurrent = null;
    Pattern colon = Pattern.compile(":");
    Pattern exclamation = Pattern.compile("!");
    Pattern spaces = Pattern.compile("\\s+");

    private void init(G g, String file, String defaultNamespace) {
        this.g = g;
        this.graphURI = g.getURI();
        this.filepath = file;
        this.defaultNamespace = defaultNamespace;
        this.format_version = "undefined";
        this.oboTerms = new HashMap();
        this.oboTypes = new HashMap();
        this.inverseRel = new HashMap();
        this.oboTermCurrent = null;
        this.oboTypeCurrent = null;
    }

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        String defaultNamespaceVal = (String)conf.getParameter("default-namespace");
        if (defaultNamespaceVal == null) {
            this.defaultNamespace = g.getURI().getNamespace();
            this.logger.info("OBO loader set default-namespace " + this.defaultNamespace);
        } else {
            this.defaultNamespace = defaultNamespaceVal;
        }
        this.init(g, conf.getLoc(), this.defaultNamespace);
        this.logger.info("-------------------------------------");
        this.logger.info("Loading OBO specification from:" + this.filepath);
        this.logger.info("-------------------------------------");
        this.loadOboSpec();
        this.logger.info("OBO specification loaded.");
        this.logger.info("-------------------------------------");
    }

    private void loadOboSpec() throws SLIB_Exception {
        try {
            String line;
            FileInputStream fstream = new FileInputStream(this.filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            boolean metadataLoaded = false;
            String subClassOfURI = RDFS.SUBCLASSOF.stringValue();
            String gNamespace = this.g.getURI().getNamespace();
            while ((line = br.readLine()) != null) {
                String flag = null;
                String value = null;
                String[] data = null;
                line = line.trim();
                if (!metadataLoaded) {
                    if (line.equals("[Term]") || line.equals("[Typedef]")) {
                        metadataLoaded = true;
                        if (!this.format_version.equals("1.2") && !this.allow_all_gafVersion) {
                            throw new SLIB_Ex_Warning("Parser of format-version '1.2' used to load OBO version '" + this.format_version + "'");
                        }
                        if (line.equals("[Term]")) {
                            this.onTermSpec = true;
                            continue;
                        }
                        this.onTypeDef = true;
                        continue;
                    }
                    data = this.getDataColonSplit(line);
                    if (data == null || !data[0].equals("format-version")) continue;
                    this.format_version = data[1];
                    continue;
                }
                if (this.onTermSpec) {
                    this.checkLine(line);
                    if (!this.onTermSpec || (data = this.getDataColonSplit(line)) == null || data.length != 2) continue;
                    flag = data[0];
                    value = data[1];
                    if (flag.equals("id")) {
                        this.oboTermCurrent = new OboTerm();
                        this.oboTermCurrent.setURIstring(this.buildURI(value));
                        continue;
                    }
                    if (flag.equals("is_a")) {
                        this.oboTermCurrent.addRel(subClassOfURI, this.buildURI(value));
                        continue;
                    }
                    if (flag.equals("is_obsolete")) {
                        if (!value.equals("true")) continue;
                        this.oboTermCurrent.setObsolete(true);
                        continue;
                    }
                    if (!flag.equals("relationship")) continue;
                    String[] datasub = this.spaces.split(value);
                    String relType = this.buildURI(datasub[0].trim());
                    String targetURI = this.buildURI(datasub[1].trim());
                    this.oboTermCurrent.addRel(relType, targetURI);
                    continue;
                }
                if (!this.onTypeDef) continue;
                this.checkLine(line);
                if (!this.onTypeDef || (data = this.getDataColonSplit(line)) == null || data.length != 2) continue;
                flag = data[0];
                value = data[1];
                if (flag.equals("id")) {
                    this.oboTypeCurrent = new OboType(this.buildURI(value));
                    continue;
                }
                if (flag.equals("is_transitive")) {
                    if (!value.equals("true")) continue;
                    this.oboTypeCurrent.setTransitivity(true);
                    continue;
                }
                if (flag.equals("inverse_of")) {
                    String uri_opp = this.buildURI(value);
                    this.setOppositeRel(this.oboTypeCurrent.getURIstring(), uri_opp);
                    this.setOppositeRel(uri_opp, this.oboTypeCurrent.getURIstring());
                    continue;
                }
                if (flag.equals("is_symmetric")) {
                    if (!value.equals("true")) continue;
                    this.oboTypeCurrent.setSymmetricity(true);
                    this.setOppositeRel(this.oboTypeCurrent.getURIstring(), this.oboTypeCurrent.getURIstring());
                    continue;
                }
                if (!flag.equals("is_obsolete") || !value.equals("true")) continue;
                this.oboTypeCurrent.setObsolete(true);
            }
            this.handleElement();
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.loadGraph();
        this.logger.info("OBO Loading ok.");
    }

    private String buildURI(String value) throws SLIB_Ex_Critic {
        String[] info = this.getDataColonSplit(value);
        if (info != null && info.length == 2) {
            String ns = this.data.getNamespace(info[0]);
            if (ns == null) {
                throw new SLIB_Ex_Critic("No namespace associated to prefix " + info[0] + ". Cannot load " + value + ", please load required namespace prefix");
            }
            return ns + info[1];
        }
        return this.defaultNamespace + value;
    }

    private void checkLine(String line) throws SLIB_Ex_Critic {
        if (line.equals("[Term]")) {
            this.handleElement();
            this.onTermSpec = true;
            this.onTypeDef = false;
        } else if (line.equals("[Typedef]")) {
            this.handleElement();
            this.onTermSpec = false;
            this.onTypeDef = true;
        }
    }

    private void handleElement() throws SLIB_Ex_Critic {
        if (this.onTermSpec) {
            this.handleTerm();
        } else if (this.onTypeDef) {
            this.handleTypeDef();
        }
    }

    private void setOppositeRel(String uri, String oppositeURI) throws SLIB_Ex_Critic {
        if (this.inverseRel.containsKey(uri) && !this.inverseRel.get(uri).equals(oppositeURI)) {
            String error = "\nError trying to set [Typedef] '" + uri + "' inverse as '" + oppositeURI + "'" + " because '" + this.inverseRel.get(uri) + "'" + " was already set as it inverse.\n" + "Please correct [Typedef] '" + uri + "' & " + "[Typedef] '" + oppositeURI + "' specification.";
            throw new SLIB_Ex_Critic(error);
        }
        this.inverseRel.put(uri, oppositeURI);
    }

    private void handleTerm() throws SLIB_Ex_Critic {
        if (this.onTermSpec) {
            if (this.oboTerms.containsKey(this.oboTermCurrent.getURIstring())) {
                throw new SLIB_Ex_Critic("Duplicate entry for [Term] " + this.oboTermCurrent.getURIstring());
            }
            this.oboTerms.put(this.oboTermCurrent.getURIstring(), this.oboTermCurrent);
            this.oboTermCurrent = new OboTerm();
        }
    }

    private void handleTypeDef() throws SLIB_Ex_Critic {
        if (this.onTypeDef) {
            if (this.oboTypes.containsKey(this.oboTypeCurrent.getURIstring())) {
                throw new SLIB_Ex_Critic("Duplicate entry for [Typedef] " + this.oboTypeCurrent.getURIstring());
            }
            this.oboTypes.put(this.oboTypeCurrent.getURIstring(), this.oboTypeCurrent);
            this.oboTermCurrent = new OboTerm();
        }
    }

    private String[] getDataColonSplit(String line) {
        if (line.isEmpty()) {
            return null;
        }
        String[] data = this.colon.split(this.exclamation.split(line, 2)[0], 2);
        data[0] = data[0].trim();
        if (data.length > 1) {
            data[1] = data[1].trim();
        }
        return data;
    }

    private void loadGraph() throws SLIB_Exception {
        int nbObsolete = 0;
        int nbObsoleteTypeDef = 0;
        for (Map.Entry<String, OboTerm> e : this.oboTerms.entrySet()) {
            if (!e.getValue().isObsolete()) {
                URI uRI = this.data.getURI(e.getKey());
                this.g.addV(uRI);
                continue;
            }
            ++nbObsolete;
        }
        HashSet<String> obsoletesETypes = new HashSet<String>();
        for (Map.Entry<String, OboType> entry : this.oboTypes.entrySet()) {
            String eTypeUriString = entry.getKey();
            OboType type = entry.getValue();
            if (!type.isObsolete()) continue;
            ++nbObsoleteTypeDef;
            obsoletesETypes.add(eTypeUriString);
        }
        for (Map.Entry<String, Object> entry : this.oboTerms.entrySet()) {
            OboTerm t = (OboTerm)entry.getValue();
            if (t.isObsolete()) continue;
            for (OboRelationship r : t.getRelationships()) {
                String typeString = r.getTypeUriString();
                if (obsoletesETypes.contains(typeString)) continue;
                URI srcURI = this.data.getURI(t.getURIstring());
                URI targetURI = this.data.getURI(r.getTargetUriString());
                URI type = this.data.getURI(typeString);
                this.g.addV(targetURI);
                this.g.addE(srcURI, type, targetURI);
            }
        }
        this.logger.info("Term specified : " + this.oboTerms.size());
        this.logger.info("skipping " + nbObsolete + " obsolete Terms");
        if (nbObsoleteTypeDef != 0) {
            this.logger.info("skipping " + nbObsoleteTypeDef + " obsolete Type Def");
        }
    }

    public boolean isAllow_all_gafVersion() {
        return this.allow_all_gafVersion;
    }

    public void setAllow_all_gafVersion(boolean allow_all_gafVersion) {
        this.allow_all_gafVersion = allow_all_gafVersion;
    }
}

