/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.bio.snomedct;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.impl.graph.elements.Edge;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class GraphLoaderSnomedCT_RF2
implements GraphLoader {
    public static final String ARG_CONCEPT_FILE = "concept_file";
    public static final String ARG_RELATIONSHIP_FILE = "relationship_file";
    public static final String ARG_PREFIX = "prefix";
    public static final String ARG_LOAD_INACTIVE_CONCEPTS = "load_inactive_concepts";
    public static final String ARG_LOAD_INACTIVE_RELATIONSHIPS = "load_inactive_relationships";
    public static final String ID_SUBCLASSOF_SNOMED = "116680003";
    Map<String, URI> conceptMap = new HashMap<String, URI>();
    Logger logger = LoggerFactory.getLogger(this.getClass());
    Pattern p_tab = Pattern.compile("\\t");
    URIFactory repo = URIFactoryMemory.getSingleton();
    public static Map<String, URI> idMapping = new HashMap<String, URI>(){
        {
            this.put(GraphLoaderSnomedCT_RF2.ID_SUBCLASSOF_SNOMED, RDFS.SUBCLASSOF);
        }
    };
    private final int CONCEPT_ID = 0;
    private final int CONCEPT_ACTIVE = 2;
    private final int CONCEPT_DATE = 1;
    private final int RELATIONSHIP_ID = 0;
    private final int RELATIONSHIP_DATE = 1;
    private final int RELATIONSHIP_ACTIVE = 2;
    private final int RELATIONSHIP_SOURCE_CONCEPT_ID = 4;
    private final int RELATIONSHIP_TARGET_CONCEPT_ID = 5;
    private final int RELATIONSHIP_TYPE_ID = 7;
    private boolean LOAD_ONLY_ACTIVE_CONCEPTS = true;
    private boolean LOAD_ONLY_ACTIVE_RELATIONSHIPS = true;

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        String load_inactive_relationships;
        String load_inactive_concepts;
        String concept_file = (String)conf.getParameter(ARG_CONCEPT_FILE);
        String relationship_file = (String)conf.getParameter(ARG_RELATIONSHIP_FILE);
        String prefix = (String)conf.getParameter(ARG_PREFIX);
        if (conf.existsParam(ARG_LOAD_INACTIVE_CONCEPTS) && (load_inactive_concepts = conf.getParameter(ARG_LOAD_INACTIVE_CONCEPTS).toString()).equalsIgnoreCase("true")) {
            this.LOAD_ONLY_ACTIVE_CONCEPTS = false;
        }
        if (conf.existsParam(ARG_LOAD_INACTIVE_RELATIONSHIPS) && (load_inactive_relationships = conf.getParameter(ARG_LOAD_INACTIVE_RELATIONSHIPS).toString()).equalsIgnoreCase("true")) {
            this.LOAD_ONLY_ACTIVE_RELATIONSHIPS = false;
        }
        this.logger.info("-------------------------------------");
        this.logger.info("Loading SNOMED-CT [RF2]      ");
        this.logger.info("-------------------------------------");
        this.logger.info("Concept file:      " + concept_file);
        this.logger.info("Relationship file: " + relationship_file);
        if (concept_file == null) {
            throw new SLIB_Ex_Critic("Please specify a file containing the concept specification, argument concept_file");
        }
        if (relationship_file == null) {
            throw new SLIB_Ex_Critic("Please specify a file containing the relationship specification, argument relationship_file");
        }
        if (prefix == null && g.getURI() != null) {
            prefix = g.getURI().getNamespace();
        }
        this.logger.info("Loading concepts");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        HashMap<String, ConceptSnomedCT> concepts = new HashMap<String, ConceptSnomedCT>();
        try {
            String[] data;
            String line;
            FileInputStream fstream = new FileInputStream(concept_file);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            boolean header = true;
            while ((line = br.readLine()) != null) {
                if (header) {
                    header = false;
                    continue;
                }
                data = this.p_tab.split(line);
                Date date = formatter.parse(data[1]);
                if (concepts.containsKey(data[0])) {
                    ConceptSnomedCT cExists = (ConceptSnomedCT)concepts.get(data[0]);
                    if (!cExists.date.before(date)) continue;
                    ConceptSnomedCT newConcept = new ConceptSnomedCT(data[0], date, data[2].trim().equals("1"));
                    concepts.put(data[0], newConcept);
                    continue;
                }
                ConceptSnomedCT concept = new ConceptSnomedCT(data[0], date, data[2].trim().equals("1"));
                concepts.put(data[0], concept);
            }
            in.close();
            long loaded = 0L;
            for (ConceptSnomedCT concept : concepts.values()) {
                if (this.LOAD_ONLY_ACTIVE_CONCEPTS && !concept.active) continue;
                URI cURI = this.repo.getURI(prefix, concept.id);
                this.conceptMap.put(concept.id, cURI);
                ++loaded;
            }
            this.logger.info("Number of activeconcepts loaded " + loaded + " on " + concepts.size() + " concepts");
            this.logger.info("Relationship file: " + relationship_file);
            in = new DataInputStream(new FileInputStream(relationship_file));
            br = new BufferedReader(new InputStreamReader(in));
            HashMap<String, RelationshipSnomedCT> relationships = new HashMap<String, RelationshipSnomedCT>();
            header = true;
            long c = 0L;
            this.logger.info("Loading relationships information... please wait");
            while ((line = br.readLine()) != null) {
                if (header) {
                    header = false;
                    continue;
                }
                if (++c % 100000L == 0L) {
                    this.logger.debug("Processed " + c + "\t" + relationships.size() + " relationships information loaded");
                }
                data = this.p_tab.split(line);
                Date date = formatter.parse(data[1]);
                if (relationships.containsKey(data[0])) {
                    RelationshipSnomedCT rExists = (RelationshipSnomedCT)relationships.get(data[0]);
                    if (rExists.date.after(date)) continue;
                    RelationshipSnomedCT newRelationship = new RelationshipSnomedCT(data[4], data[5], data[7], date, data[2].trim().equals("1"));
                    relationships.put(data[0], newRelationship);
                    continue;
                }
                RelationshipSnomedCT newRelationship = new RelationshipSnomedCT(data[4], data[5], data[7], date, data[2].trim().equals("1"));
                relationships.put(data[0], newRelationship);
            }
            double relationship_count = 0.0;
            this.logger.info("Adding relationships to the graph... please wait");
            for (RelationshipSnomedCT r : relationships.values()) {
                if (this.LOAD_ONLY_ACTIVE_RELATIONSHIPS && !r.active || !this.conceptMap.containsKey(r.source) || !this.conceptMap.containsKey(r.target)) continue;
                URI src = this.conceptMap.get(r.source);
                URI tar = this.conceptMap.get(r.target);
                URI pred = idMapping.containsKey(r.relationshipID) ? idMapping.get(r.relationshipID) : this.repo.getURI(prefix, r.relationshipID);
                Edge e = new Edge(src, pred, tar);
                g.addE((E)e);
                relationship_count += 1.0;
            }
            this.logger.info("Number of relationships loaded: " + relationship_count);
            this.logger.info("-------------------------------------");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
    }

    class ConceptSnomedCT {
        String id;
        Date date;
        boolean active;

        public ConceptSnomedCT(String id, Date d, boolean isActive) {
            this.id = id;
            this.date = d;
            this.active = isActive;
        }
    }

    class RelationshipSnomedCT {
        String source;
        String target;
        Date date;
        boolean active;
        String relationshipID;

        public RelationshipSnomedCT(String src, String tgt, String rID, Date d, boolean isActive) {
            this.source = src;
            this.target = tgt;
            this.date = d;
            this.relationshipID = rID;
            this.active = isActive;
        }
    }
}

