/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.loader.rdf;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RDFXMLParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sail.memory.model.MemValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.loader.GraphLoader;
import slib.graph.io.loader.rdf.SlibRdfHandler;
import slib.graph.io.util.GFormat;
import slib.graph.model.graph.G;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class RDFLoader
implements GraphLoader {
    RDFParser parser = null;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    public RDFLoader() {
    }

    public RDFLoader(RDFFormat format) throws SLIB_Ex_Critic {
        this.buildRDFparser(format);
    }

    @Override
    public void populate(GDataConf conf, G g) throws SLIB_Exception {
        this.loadConf(conf);
        this.logger.info("-------------------------------------");
        this.logger.info(" RDF Loader");
        this.logger.info("-------------------------------------");
        this.logger.info("Populate graph " + g.getURI() + " from " + conf.getLoc());
        this.load(g, conf.getLoc());
        this.logger.info("Graph " + g.getURI() + " populated by RDF data ");
        this.logger.info("-------------------------------------");
    }

    private void loadConf(GDataConf conf) throws SLIB_Ex_Critic {
        GFormat format = conf.getFormat();
        if (format == GFormat.RDF_XML) {
            this.buildRDFparser(RDFFormat.RDFXML);
        } else if (format == GFormat.NTRIPLES) {
            this.buildRDFparser(RDFFormat.NTRIPLES);
        } else if (format == GFormat.TURTLE) {
            this.buildRDFparser(RDFFormat.TURTLE);
        } else {
            throw new SLIB_Ex_Critic("Unsupported RDF format " + (Object)((Object)format));
        }
    }

    private void buildRDFparser(RDFFormat format) throws SLIB_Ex_Critic {
        if (format.equals((Object)RDFFormat.NTRIPLES)) {
            this.parser = new NTriplesParser((ValueFactory)new MemValueFactory());
        } else if (format.equals((Object)RDFFormat.RDFXML)) {
            this.parser = new RDFXMLParser((ValueFactory)new MemValueFactory());
        } else if (format.equals((Object)RDFFormat.TURTLE)) {
            this.parser = new TurtleParser((ValueFactory)new MemValueFactory());
        } else {
            throw new SLIB_Ex_Critic("Unsupported RDF format " + format);
        }
        ParserConfig config = new ParserConfig();
        this.parser.setParserConfig(config);
    }

    public void load(G g, String file) throws SLIB_Ex_Critic {
        try {
            this.load(g, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (SLIB_Ex_Critic e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void load(G g, InputStream inputStream) throws SLIB_Ex_Critic {
        SlibRdfHandler rdfHandler = new SlibRdfHandler(g);
        try {
            this.logger.info("Parser loaded for: " + this.parser.getRDFFormat());
            this.parser.setRDFHandler((RDFHandler)rdfHandler);
            this.logger.info("Parsing RDF file...");
            this.parser.parse(inputStream, "");
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (RDFParseException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (RDFHandlerException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void load(G g, String file, RDFFormat format) throws SLIB_Ex_Critic {
        this.buildRDFparser(format);
        this.load(g, file);
    }

    public void load(G g, Map<String, RDFFormat> rdfFileConf) throws SLIB_Ex_Critic {
        for (Map.Entry<String, RDFFormat> e : rdfFileConf.entrySet()) {
            this.load(g, e.getKey(), e.getValue());
        }
    }
}

