/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.io.plotter;

import java.util.HashMap;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.repo.URIFactory;
import slib.indexer.IndexHash;

public class GraphPlotter_Graphviz {
    static Logger logger = LoggerFactory.getLogger(GraphPlotter_Graphviz.class);

    public static String plot(URIFactory factory, G graph, Set<URI> VertexUriColored, boolean showLabels) {
        return GraphPlotter_Graphviz.plot(factory, graph, VertexUriColored, showLabels, true, null);
    }

    public static String plot(URIFactory factory, G graph, Set<URI> VertexColored, boolean showLabels, boolean showSubSlassOfLabels, IndexHash index) {
        String color;
        logger.debug("Plot: " + graph.getURI());
        logger.debug("prefixes: " + factory.getURIPrefixes());
        HashMap<URI, String> relColor = new HashMap<URI, String>();
        relColor.put(RDFS.SUBCLASSOF, "black");
        String defColor_v = "\"white\"";
        String defColor_q_v = "\"#FAAB9F\"";
        String defColor_e = "black";
        String style = "\n\trankdir=BT;\n\tnode [style=filled,shape=rect]\n\n";
        String out = "digraph plottedgraph {\n";
        out = out + style;
        for (URI uri : graph.getV()) {
            color = defColor_v;
            if (VertexColored != null && VertexColored.contains(uri)) {
                color = defColor_q_v;
            }
            if (index != null && index.containsDescriptionFor(uri)) {
                String indexVal = index.getDescription(uri).getPreferredDescription() + " [" + factory.shortURIasString(uri) + "]";
                String splittedLabel = GraphPlotter_Graphviz.splitString(indexVal, 20);
                out = out + "\t\"" + splittedLabel + "\"[fillcolor=" + color + "];\n";
                continue;
            }
            out = out + "\t\"" + factory.shortURIasString(uri) + "\"[color=" + color + "];\n";
        }
        for (E e : graph.getE()) {
            URI predicate = e.getURI();
            color = defColor_e;
            if (relColor.containsKey(predicate)) {
                color = (String)relColor.get(predicate);
            }
            String info = "";
            if (showLabels && (showSubSlassOfLabels || !predicate.equals((Object)RDFS.SUBCLASSOF))) {
                String predicateLabel = factory.shortURIasString(predicate);
                if (index != null && index.containsDescriptionFor(predicate)) {
                    predicateLabel = index.getDescription(predicate).getPreferredDescription();
                }
                info = "[label=\"" + predicateLabel + "\",color=" + color + "]";
            }
            URI s = e.getSource();
            URI t = e.getTarget();
            String source = factory.shortURIasString(s);
            String target = factory.shortURIasString(t);
            if (index != null) {
                if (index.containsDescriptionFor(s)) {
                    source = GraphPlotter_Graphviz.splitString(index.getDescription(s).getPreferredDescription() + " [" + factory.shortURIasString(s) + "]", 20);
                }
                if (index.containsDescriptionFor(e.getTarget())) {
                    target = GraphPlotter_Graphviz.splitString(index.getDescription(t).getPreferredDescription() + " [" + factory.shortURIasString(t) + "]", 20);
                }
            }
            out = out + "\t\"" + source + "\" -> \"" + target + "\" " + info + ";\n";
        }
        out = out + "}\n";
        return out;
    }

    public static String splitString(String in, int max_num_per_string) {
        String[] data = in.split(" ");
        String newLabel = "";
        int curLineLength = 0;
        for (String d : data) {
            if (curLineLength + d.length() + 1 <= max_num_per_string) {
                newLabel = newLabel + d + " ";
                curLineLength += d.length() + 1;
                continue;
            }
            if (curLineLength == 0 && d.length() > max_num_per_string) {
                newLabel = newLabel + d + "\\n";
                curLineLength = 0;
                continue;
            }
            if (curLineLength + d.length() + 1 > max_num_per_string) {
                newLabel = newLabel + "\\n" + d + " ";
                curLineLength = d.length() + 1;
                continue;
            }
            if (curLineLength + d.length() + 1 > max_num_per_string) {
                newLabel = newLabel + "\\n" + d + " ";
                curLineLength = d.length() + 1;
                continue;
            }
            if (curLineLength + d.length() + 1 <= max_num_per_string) continue;
            newLabel = newLabel + "\\n" + d + " ";
            curLineLength = d.length() + 1;
        }
        return newLabel;
    }
}

