/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import info.aduna.text.ASCIIUtil;
import info.aduna.text.StringUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurtleUtil {
    private static final Logger logger = LoggerFactory.getLogger(TurtleUtil.class);
    public static final char[] LOCAL_ESCAPED_CHARS = new char[]{'_', '~', '.', '-', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', '/', '?', '#', '@', '%'};

    public static int findURISplitIndex(String uri) {
        int idx;
        int uriLength = uri.length();
        for (idx = uriLength - 1; idx >= 0 && TurtleUtil.isNameChar(uri.charAt(idx)); --idx) {
        }
        ++idx;
        while (idx < uriLength && !TurtleUtil.isNameStartChar(uri.charAt(idx))) {
            ++idx;
        }
        if (!TurtleUtil.isNameEndChar(uri.charAt(uriLength - 1))) {
            return -1;
        }
        if (idx > 0 && idx < uriLength) {
            return idx;
        }
        return -1;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    public static boolean isPN_CHARS_BASE(int c) {
        return ASCIIUtil.isLetter((int)c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    public static boolean isPN_CHARS_U(int c) {
        return TurtleUtil.isPN_CHARS_BASE(c) || c == 95;
    }

    public static boolean isPN_CHARS(int c) {
        return TurtleUtil.isPN_CHARS_U(c) || ASCIIUtil.isNumber((int)c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    public static boolean isPrefixStartChar(int c) {
        return TurtleUtil.isPN_CHARS_BASE(c);
    }

    public static boolean isNameStartChar(int c) {
        return TurtleUtil.isPN_CHARS_U(c) || c == 58 || ASCIIUtil.isNumber((int)c) || c == 92 || c == 37;
    }

    public static boolean isNameChar(int c) {
        return TurtleUtil.isPN_CHARS(c) || c == 46 || c == 58 | c == 92 || c == 37;
    }

    public static boolean isNameEndChar(int c) {
        return TurtleUtil.isPN_CHARS(c) || c == 58;
    }

    public static boolean isLocalEscapedChar(int c) {
        return Arrays.binarySearch(LOCAL_ESCAPED_CHARS, (char)c) > -1;
    }

    public static boolean isPrefixChar(int c) {
        return TurtleUtil.isPN_CHARS_BASE(c) || TurtleUtil.isPN_CHARS(c) || c == 46;
    }

    public static boolean isLanguageStartChar(int c) {
        return ASCIIUtil.isLetter((int)c);
    }

    public static boolean isLanguageChar(int c) {
        return ASCIIUtil.isLetter((int)c) || ASCIIUtil.isNumber((int)c) || c == 45;
    }

    public static boolean isPN_PREFIX(String prefix) {
        if (prefix.length() == 0) {
            logger.debug("PN_PREFIX was not valid (empty)");
            return false;
        }
        if (!TurtleUtil.isPN_CHARS_BASE(prefix.charAt(0))) {
            logger.debug("PN_PREFIX was not valid (start character invalid) i=0 nextchar={} prefix=", (Object)Character.valueOf(prefix.charAt(0)), (Object)prefix);
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (!TurtleUtil.isPN_CHARS(prefix.charAt(i)) || prefix.charAt(i) == '.' && i < prefix.length() - 1) {
                logger.debug("PN_PREFIX was not valid (intermediate character invalid) i=" + i + " nextchar={} prefix={}", (Object)Character.valueOf(prefix.charAt(i)), (Object)prefix);
                return false;
            }
            if (prefix.charAt(i) != '%' || prefix.length() - i >= 2) continue;
            logger.debug("PN_PREFIX was not valid (percent encoding) i=" + i + " nextchar={} prefix={}", (Object)Character.valueOf(prefix.charAt(i)), (Object)prefix);
            return false;
        }
        return true;
    }

    public static boolean isPLX_START(String name) {
        if (name.length() >= 3 && TurtleUtil.isPERCENT(name.substring(0, 3))) {
            return true;
        }
        return name.length() >= 2 && TurtleUtil.isPN_LOCAL_ESC(name.substring(0, 2));
    }

    public static boolean isPERCENT(String name) {
        if (name.length() != 3) {
            return false;
        }
        if (name.charAt(0) != '%') {
            return false;
        }
        return ASCIIUtil.isHex((int)name.charAt(1)) && ASCIIUtil.isHex((int)name.charAt(2));
    }

    public static boolean isPLX_INTERNAL(String name) {
        if (name.length() == 3 && TurtleUtil.isPERCENT(name)) {
            return true;
        }
        return name.length() == 2 && TurtleUtil.isPN_LOCAL_ESC(name);
    }

    public static boolean isPN_LOCAL_ESC(String name) {
        if (name.length() != 2) {
            return false;
        }
        if (!name.startsWith("\\")) {
            return false;
        }
        return Arrays.binarySearch(LOCAL_ESCAPED_CHARS, name.charAt(1)) > -1;
    }

    public static boolean isPN_LOCAL(String name) {
        if (name.length() == 0) {
            return true;
        }
        if (!(TurtleUtil.isPN_CHARS_U(name.charAt(0)) || name.charAt(0) == ':' || ASCIIUtil.isNumber((int)name.charAt(0)) || TurtleUtil.isPLX_START(name))) {
            System.err.println("PN_LOCAL was not valid (start characters invalid) i=0 nextchar=" + name.charAt(0) + " name=" + name);
            return false;
        }
        if (!TurtleUtil.isNameStartChar(name.charAt(0))) {
            System.err.println("name was not valid (start character invalid) i=0 nextchar=" + name.charAt(0) + " name=" + name);
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (!TurtleUtil.isNameChar(name.charAt(i))) {
                System.err.println("name was not valid (intermediate character invalid) i=" + i + " nextchar=" + name.charAt(i) + " name=" + name);
                return false;
            }
            if (name.charAt(i) != '%' || name.length() - i >= 3) continue;
            System.err.println("name was not valid (short percent escape) i=" + i + " nextchar=" + name.charAt(i) + " name=" + name);
            return false;
        }
        return true;
    }

    public static String encodeString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)"\t", (String)"\\t", (String)s);
        s = StringUtil.gsub((String)"\n", (String)"\\n", (String)s);
        s = StringUtil.gsub((String)"\r", (String)"\\r", (String)s);
        s = StringUtil.gsub((String)"\"", (String)"\\\"", (String)s);
        return s;
    }

    public static String encodeLongString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)"\"", (String)"\\\"", (String)s);
        return s;
    }

    public static String encodeURIString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)">", (String)"\\>", (String)s);
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }

    static {
        Arrays.sort(LOCAL_ESCAPED_CHARS);
    }
}

