/*
 * Decompiled with CFR 0.152.
 */
package slib.indexer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.URI;
import slib.indexer.URIDescription;

public final class URIDescriptionBasic
implements URIDescription {
    URI associatedURI;
    String preferredDescription;
    Set<String> descriptions;

    public URIDescriptionBasic(URI v) {
        this.associatedURI = v;
        this.descriptions = new HashSet<String>();
    }

    public URIDescriptionBasic(URI v, String d) {
        this(v);
        this.setPreferredDescription(d);
    }

    @Override
    public void addDescription(String d) {
        this.descriptions.add(d);
    }

    @Override
    public Set<String> getDescriptions() {
        return this.descriptions;
    }

    @Override
    public String getPreferredDescription() {
        return this.preferredDescription;
    }

    @Override
    public void setPreferredDescription(String d) {
        this.preferredDescription = d;
        this.descriptions.add(d);
    }

    @Override
    public void addDescriptions(Collection<String> d) {
        this.descriptions.addAll(d);
    }

    @Override
    public void addDescriptions(String[] d) {
        this.descriptions.addAll(Arrays.asList(d));
    }

    @Override
    public URI getAssociatedURI() {
        return this.associatedURI;
    }

    @Override
    public void removeDescription(String d) {
        this.descriptions.remove(d);
        if (this.preferredDescription.equals(d)) {
            this.preferredDescription = null;
        }
    }

    @Override
    public void removeDescriptions(Collection<String> d) {
        for (String desc : d) {
            this.removeDescription(desc);
        }
    }
}

