/*
 * Decompiled with CFR 0.152.
 */
package slib.indexer.mesh;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import slib.graph.model.repo.URIFactory;
import slib.indexer.IndexHash;
import slib.indexer.URIDescriptionBasic;
import slib.indexer.mesh.MeshDescriptor;
import slib.indexer.mesh.MeshXMLHandler;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Indexer_MESH_XML {
    static Logger logger = LoggerFactory.getLogger(Indexer_MESH_XML.class);
    static Set<MeshDescriptor> descriptors = new HashSet<MeshDescriptor>();
    static URIFactory factory;
    static String default_namespace;

    public static IndexHash buildIndex(URIFactory factory, String filepath, String defaultNamespace) throws SLIB_Exception {
        Indexer_MESH_XML.factory = factory;
        default_namespace = defaultNamespace;
        IndexHash index = new IndexHash();
        try {
            logger.info(" Mesh XML Indexer");
            SAXParserFactory f = SAXParserFactory.newInstance();
            SAXParser saxParser = f.newSAXParser();
            saxParser.parse(filepath, (DefaultHandler)new MeshXMLHandler(descriptors));
            logger.info("Number of descriptor loaded " + descriptors.size());
            logger.info("Generating relationships ");
            for (MeshDescriptor c : descriptors) {
                String uriConceptAsString = default_namespace + c.getDescriptorUI();
                URI uriConcept = factory.getURI(uriConceptAsString);
                URIDescriptionBasic i = new URIDescriptionBasic(uriConcept, c.descriptorName);
                i.addDescriptions(c.descriptions);
                index.addDescription(uriConcept, i);
            }
        }
        catch (IOException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        catch (SAXException ex) {
            throw new SLIB_Ex_Critic(ex.getMessage());
        }
        logger.info("MESH loader - process performed");
        return index;
    }
}

