/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.module;

import java.util.Comparator;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.tools.module.ModuleCst;
import slib.tools.module.OptionComparator;
import slib.tools.module.ToolCmdHandlerCst;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public abstract class CmdHandler {
    public ModuleCst cst;
    public ToolCmdHandlerCst cstCmd;
    public Options options;
    public HelpFormatter helpFormatter;
    private String USAGE;
    private final String HEADER = "----------------------------------------------------------------------";
    private final String FOOTER = "----------------------------------------------------------------------";
    static Logger logger = LoggerFactory.getLogger(CmdHandler.class);
    Comparator<Option> comparator;

    public CmdHandler(ModuleCst cst, ToolCmdHandlerCst cstCmd) throws SLIB_Exception {
        this.cst = cst;
        this.cstCmd = cstCmd;
        this.USAGE = "java -jar " + this.cstCmd.getAppCmdName() + " [arguments]";
        this.comparator = new OptionComparator(cstCmd.getOptionOrder());
        logger.info("----------------------------------------------------------------------");
        logger.info("\t" + cst.getAppName() + " " + cst.getVersion());
        logger.info("----------------------------------------------------------------------");
        this.showDescription();
        this.showRef();
        if (cst.reference != null) {
            logger.info("----------------------------------------------------------------------");
        }
        this.options = new Options();
        for (Option o : cstCmd.getOptionOrder().keySet()) {
            this.options.addOption(o);
        }
        this.helpFormatter = new HelpFormatter();
        this.helpFormatter.setOptionComparator(this.comparator);
    }

    public abstract void processArgs(String[] var1) throws SLIB_Exception;

    public void showCmdLineExamples() throws SLIB_Exception {
        throw new SLIB_Ex_Critic("No command line examples, sorry");
    }

    public final void showDescription() {
        if (this.cst.getDescription() != null) {
            logger.info(this.cst.getDescription());
        }
    }

    public void showContact() {
        if (this.cst.getContact() != null) {
            logger.info("Contact: " + this.cst.getContact());
        }
    }

    public final void showRef() {
        if (this.cst.getReference() != null) {
            logger.info("\nPlease cite: \n" + this.cst.getReference());
        }
    }

    public void ending(String message, boolean showHelp, boolean showDesc, boolean showContact) {
        if (message != null) {
            logger.info("----------------------------------------------------------------------");
            logger.info(message);
        }
        if (showDesc) {
            this.showDescription();
        }
        if (showContact) {
            this.showContact();
        }
        if (showHelp) {
            this.helpFormatter.printHelp(this.USAGE, "----------------------------------------------------------------------", this.options, "----------------------------------------------------------------------");
        }
        System.exit(0);
    }

    public void ending(String message, boolean showHelp) {
        this.ending(message, showHelp, false, true);
    }
}

