/*
 * Decompiled with CFR 0.152.
 */
package slib.tools.module;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import slib.graph.algo.utils.GAction;
import slib.graph.algo.utils.GActionType;
import slib.graph.io.conf.GDataConf;
import slib.graph.io.conf.GraphConf;
import slib.graph.io.loader.csv.CSV_Mapping;
import slib.graph.io.loader.csv.CSV_StatementTemplate;
import slib.graph.io.loader.csv.CSV_StatementTemplate_Constraint;
import slib.graph.io.loader.csv.StatementTemplateElement;
import slib.graph.io.loader.csv.StatementTemplate_Constraint_Type;
import slib.graph.io.loader.utils.filter.graph.Filter;
import slib.graph.io.loader.utils.filter.graph.repo.FilterRepository;
import slib.graph.io.util.GFormat;
import slib.graph.model.impl.repo.URIFactoryMemory;
import slib.graph.model.repo.URIFactory;
import slib.tools.module.FilterBuilderGeneric;
import slib.tools.module.GenericConfBuilder;
import slib.tools.module.GlobalConfPattern;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;
import slib.utils.i.Parametrable;
import slib.utils.impl.Util;
import slib.utils.threads.ThreadManager;

public class XMLConfLoaderGeneric {
    private String xmlFile;
    private Document document;
    private URIFactory factory;
    private LinkedList<GraphConf> graphConfs;
    private LinkedHashSet<Filter> filters;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    static final Map<String, URI> admittedPType = new HashMap<String, URI>();

    public XMLConfLoaderGeneric(String xmlFile) throws SLIB_Ex_Critic {
        this.factory = URIFactoryMemory.getSingleton();
        this.xmlFile = xmlFile;
        this.graphConfs = new LinkedList();
        this.filters = new LinkedHashSet();
        this.load();
    }

    private void load() throws SLIB_Ex_Critic {
        this.logger.info("Loading XML conf from : " + this.xmlFile);
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = parser.parse(new File(this.xmlFile));
            NodeList opt = this.document.getElementsByTagName("opt");
            this.logger.debug("Loading options");
            if (opt.getLength() == 1 && opt.item(0) instanceof Element) {
                this.extractOptConf(GenericConfBuilder.build((Element)opt.item(0)));
            } else if (opt.getLength() > 1) {
                Util.error((String)"Only one opt tag allowed");
            }
            this.logger.debug("Loading variables");
            NodeList variablesConfig = this.document.getElementsByTagName("variables");
            if (variablesConfig.getLength() == 1 && variablesConfig.item(0) instanceof Element) {
                this.loadVariablesConf((Element)variablesConfig.item(0));
            } else if (variablesConfig.getLength() > 0) {
                Util.error((String)"Only one variables is admitted");
            }
            NodeList namespaces = this.document.getElementsByTagName("namespaces");
            if (namespaces.getLength() == 1 && namespaces.item(0) instanceof Element) {
                this.loadNamespaces((Element)namespaces.item(0));
            } else if (namespaces.getLength() > 1) {
                Util.error((String)"Only one namespaces tag allowed");
            }
            this.logger.debug("Loading graph configurations");
            NodeList graphsConfig = this.document.getElementsByTagName("graphs");
            if (graphsConfig.getLength() == 1 && graphsConfig.item(0) instanceof Element) {
                NodeList nListGConf = ((Element)graphsConfig.item(0)).getElementsByTagName("graph");
                for (int i = 0; i < nListGConf.getLength(); ++i) {
                    Element gConf = (Element)nListGConf.item(i);
                    this.loadGraphConf(gConf);
                }
            } else {
                Util.error((String)"Please specify a unique <graphs> tag");
            }
            this.logger.debug("Loading filters");
            NodeList filtersElement = this.document.getElementsByTagName("filters");
            if (filtersElement.getLength() == 1 && filtersElement.item(0) instanceof Element) {
                this.loadFiltersConf((Element)filtersElement.item(0));
            } else if (filtersElement.getLength() > 0) {
                Util.error((String)"Only one filters is admitted");
            }
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.logger.info("generic configuration loaded ");
    }

    private void loadNamespaces(Element item) throws SLIB_Ex_Critic {
        NodeList list = item.getElementsByTagName("nm");
        for (int i = 0; i < list.getLength(); ++i) {
            Conf m = GenericConfBuilder.build((Element)list.item(i));
            String prefix = (String)m.getParam("prefix");
            String ref = (String)m.getParam("ref");
            if (prefix == null) {
                throw new SLIB_Ex_Critic("Invalid nm tag, missing a prefix attribut");
            }
            if (ref == null) {
                throw new SLIB_Ex_Critic("Invalid nm tag, missing a ref attribut associated to variable " + prefix);
            }
            this.logger.info("add namespace prefix : " + prefix + " ref : " + ref);
            this.factory.loadNamespacePrefix(prefix, ref);
        }
    }

    private void loadGraphConf(Element item) throws SLIB_Ex_Critic {
        this.logger.debug("Loading graph conf");
        GraphConf gconf = new GraphConf();
        String uris = item.getAttribute("uri");
        uris = GenericConfBuilder.applyGlobalPatterns(uris);
        this.logger.debug("uri: " + uris);
        URI uri = this.factory.getURI(uris);
        gconf.setUri(uri);
        String[] graphDataFileDefAtt = new String[]{"format", "path"};
        NodeList nListGdata = item.getElementsByTagName("data");
        if (nListGdata.getLength() == 1 && nListGdata.item(0) instanceof Element) {
            NodeList nListGConf = ((Element)nListGdata.item(0)).getElementsByTagName("file");
            for (int i = 0; i < nListGConf.getLength(); ++i) {
                Element dataConf = (Element)nListGConf.item(i);
                Conf conf = GenericConfBuilder.build(dataConf);
                this.logger.debug("> data conf");
                String format = conf.getParamAsString("format");
                this.logger.debug("- format: " + format);
                GFormat gFormat = null;
                if (format == null) {
                    throw new SLIB_Ex_Critic("Please precise a data format for each data to import, valids " + Arrays.toString(GFormat.values()));
                }
                try {
                    gFormat = GFormat.valueOf((String)format.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new SLIB_Ex_Critic("Unknow data format " + format + ", valids " + Arrays.toString(GFormat.values()));
                }
                String path = conf.getParamAsString("path");
                this.logger.debug("- path: " + path);
                GDataConf gDataConf = new GDataConf(gFormat, path);
                this.loadExtraParameters(conf, graphDataFileDefAtt, (Parametrable)gDataConf);
                gDataConf = this.gDataConfAdditional(gFormat, dataConf, gDataConf);
                gconf.addGDataConf(gDataConf);
                this.logger.debug("");
            }
        } else {
            Util.error((String)"Please specify a unique <data> tag for each <graph> tag");
        }
        String[] graphActionDefAtt = new String[]{"type"};
        NodeList nListGactions = this.document.getElementsByTagName("actions");
        if (nListGactions.getLength() == 1 && nListGactions.item(0) instanceof Element) {
            NodeList nListGConf = ((Element)nListGactions.item(0)).getElementsByTagName("action");
            for (int i = 0; i < nListGConf.getLength(); ++i) {
                Element xmlConf = (Element)nListGConf.item(i);
                Conf conf = GenericConfBuilder.build(xmlConf);
                this.logger.debug("> action conf");
                String type = conf.getParamAsString("type");
                this.logger.debug("- type: " + type);
                GActionType gType = null;
                if (type == null) {
                    throw new SLIB_Ex_Critic("Please precise a type for each action to perform, valids " + Arrays.toString(GActionType.values()));
                }
                try {
                    gType = GActionType.valueOf((String)type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new SLIB_Ex_Critic("Unknow action type " + type + ", valids " + Arrays.toString(GActionType.values()));
                }
                GAction gAction = new GAction(gType);
                this.loadExtraParameters(conf, graphActionDefAtt, (Parametrable)gAction);
                gconf.addGAction(gAction);
            }
        } else if (nListGactions.getLength() > 1) {
            Util.error((String)"Please specify a unique <actions> tag for each <graph> tag");
        }
        this.graphConfs.add(gconf);
    }

    private GDataConf gDataConfAdditional(GFormat gFormat, Element dataConf, GDataConf gDataConf) throws SLIB_Ex_Critic {
        if (gFormat == GFormat.CSV) {
            Conf conf;
            Element xmlConf;
            int i;
            HashMap<String, StatementTemplateElement> admittedStmConstraintElement = new HashMap<String, StatementTemplateElement>();
            admittedStmConstraintElement.put("subject", StatementTemplateElement.SUBJECT);
            admittedStmConstraintElement.put("object", StatementTemplateElement.OBJECT);
            HashMap<String, StatementTemplate_Constraint_Type> admittedStmConstraintType = new HashMap<String, StatementTemplate_Constraint_Type>();
            admittedStmConstraintType.put("EXISTS", StatementTemplate_Constraint_Type.EXISTS);
            HashMap<Integer, CSV_Mapping> mappings = new HashMap<Integer, CSV_Mapping>();
            HashMap<Integer, CSV_StatementTemplate> stmtemplates = new HashMap<Integer, CSV_StatementTemplate>();
            NodeList list = dataConf.getElementsByTagName("map");
            for (i = 0; i < list.getLength(); ++i) {
                xmlConf = (Element)list.item(i);
                conf = GenericConfBuilder.build(xmlConf);
                Integer field = Util.stringToInteger((String)((String)conf.getParam("field")));
                String type = (String)conf.getParam("type");
                String prefix = (String)conf.getParam("prefix");
                if (field == null) {
                    throw new SLIB_Ex_Critic("Cannot state field number associated to mapping definition in CSV configuration");
                }
                CSV_Mapping m = new CSV_Mapping(field.intValue(), prefix);
                mappings.put(field, m);
            }
            gDataConf.addParameter("mappings", mappings);
            list = dataConf.getElementsByTagName("stm");
            for (i = 0; i < list.getLength(); ++i) {
                xmlConf = (Element)list.item(i);
                conf = GenericConfBuilder.build(xmlConf);
                Integer s_id = Util.stringToInteger((String)((String)conf.getParam("subject")));
                Integer o_id = Util.stringToInteger((String)((String)conf.getParam("object")));
                String p_string = (String)conf.getParam("predicate");
                if (s_id == null) {
                    throw new SLIB_Ex_Critic("Cannot state number associated to subject statement template in CSV configuration");
                }
                if (o_id == null) {
                    throw new SLIB_Ex_Critic("Cannot state number associated to object statement template in CSV configuration");
                }
                if (p_string == null) {
                    throw new SLIB_Ex_Critic("Cannot state number associated to predicate statement template in CSV configuration");
                }
                URI p = null;
                p = admittedPType.containsKey(p_string) ? admittedPType.get(p_string) : this.factory.getURI(p_string);
                CSV_StatementTemplate m = new CSV_StatementTemplate(s_id.intValue(), o_id.intValue(), p);
                NodeList listinner = dataConf.getElementsByTagName("constraint");
                for (int j = 0; j < listinner.getLength(); ++j) {
                    Conf confinner = GenericConfBuilder.build((Element)listinner.item(j));
                    String element = (String)confinner.getParam("element");
                    String typeString = (String)confinner.getParam("type");
                    StatementTemplateElement elem = (StatementTemplateElement)admittedStmConstraintElement.get(element);
                    StatementTemplate_Constraint_Type type = (StatementTemplate_Constraint_Type)admittedStmConstraintType.get(typeString);
                    if (elem == null) {
                        throw new SLIB_Ex_Critic("Cannot state element " + element + " associated to statement constraint definition in CSV configuration, admitted " + admittedStmConstraintElement.keySet());
                    }
                    if (type == null) {
                        throw new SLIB_Ex_Critic("Cannot state type " + typeString + " associated to statement constraint definition in CSV configuration, admitted " + admittedStmConstraintType.keySet());
                    }
                    CSV_StatementTemplate_Constraint constraint = new CSV_StatementTemplate_Constraint(elem, type);
                    m.addConstraint(constraint);
                }
                stmtemplates.put(s_id, m);
            }
            gDataConf.addParameter("statementTemplates", stmtemplates);
        }
        return gDataConf;
    }

    private void loadExtraParameters(Conf conf, String[] restrictions, Parametrable p) {
        Map map = conf.getParams();
        for (String attName : map.keySet()) {
            String attValue = conf.getParamAsString(attName);
            boolean toLoad = true;
            for (String s : restrictions) {
                if (!attName.equals(s)) continue;
                toLoad = false;
                break;
            }
            if (!toLoad) continue;
            this.logger.debug("- " + attName + ": " + attValue);
            p.addParameter(attName, (Object)attValue);
        }
    }

    private void loadVariablesConf(Element item) throws SLIB_Ex_Critic {
        NodeList list = item.getElementsByTagName("var");
        GlobalConfPattern userConf = GlobalConfPattern.getInstance();
        for (int i = 0; i < list.getLength(); ++i) {
            Conf m = GenericConfBuilder.build((Element)list.item(i));
            String key = (String)m.getParam("key");
            String value = (String)m.getParam("value");
            if (key == null) {
                throw new SLIB_Ex_Critic("Invalid var tag, missing a key attribut");
            }
            if (value == null) {
                throw new SLIB_Ex_Critic("Invalid var tag, missing a value attribut associated to variable " + key);
            }
            this.logger.info("add variable key : {" + key + "} value : " + value);
            userConf.addVar(key, value);
        }
    }

    private void loadFiltersConf(Element item) throws SLIB_Ex_Critic {
        NodeList list = item.getElementsByTagName("filter");
        LinkedHashSet<Conf> gConfGenerics = GenericConfBuilder.build(list);
        this.filters = this.buildFilters(gConfGenerics);
        for (Filter f : this.filters) {
            FilterRepository.getInstance().addFilter(f);
        }
    }

    private LinkedHashSet<Filter> buildFilters(LinkedHashSet<Conf> gConfGenerics) throws SLIB_Ex_Critic {
        for (Conf c : gConfGenerics) {
            Filter f = FilterBuilderGeneric.buildFilter(c);
            for (Filter ft : this.filters) {
                if (!ft.getId().equals(f.getId())) continue;
                throw new SLIB_Ex_Critic("Duplicate id '" + f.getId() + "' found in filter specification");
            }
            this.filters.add(f);
        }
        return this.filters;
    }

    private void extractOptConf(Conf gc) throws SLIB_Ex_Critic {
        String nbThread_s = (String)gc.getParam("threads");
        if (nbThread_s != null) {
            try {
                int nbThreads = Integer.parseInt(nbThread_s);
                ThreadManager.getSingleton().setMaxThread(nbThreads);
            }
            catch (NumberFormatException e) {
                throw new SLIB_Ex_Critic("Error converting threads to integer value ");
            }
        }
    }

    public LinkedList<GraphConf> getGraphConfs() {
        return this.graphConfs;
    }

    static {
        admittedPType.put("RDF.TYPE", RDF.TYPE);
        admittedPType.put("RDFS.SUBCLASSOF", RDFS.SUBCLASSOF);
    }
}

