/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerDataTypeFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectInverseOf;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectProperty;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationException;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationRepository;
import java.util.Objects;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;

public class ObjectPropertyExpressionTranslator
implements OWLPropertyExpressionVisitorEx<IntegerObjectPropertyExpression> {
    private final IntegerDataTypeFactory factory;
    private final TranslationRepository repository;

    public ObjectPropertyExpressionTranslator(IntegerDataTypeFactory factory, TranslationRepository repository) {
        Objects.requireNonNull(factory);
        Objects.requireNonNull(repository);
        this.factory = factory;
        this.repository = repository;
    }

    public IntegerDataTypeFactory getDataTypeFactory() {
        return this.factory;
    }

    public TranslationRepository getTranslationRepository() {
        return this.repository;
    }

    public IntegerObjectPropertyExpression visit(OWLDataProperty property) {
        Objects.requireNonNull(property);
        throw TranslationException.newUnsupportedTranslationException(property);
    }

    public IntegerObjectPropertyExpression visit(OWLObjectInverseOf property) {
        IntegerObjectInverseOf ret;
        Objects.requireNonNull(property);
        IntegerObjectPropertyExpression propExpr = (IntegerObjectPropertyExpression)property.getInverse().accept((OWLPropertyExpressionVisitorEx)this);
        if (propExpr instanceof IntegerObjectProperty) {
            ret = this.getDataTypeFactory().createObjectInverseOf((IntegerObjectProperty)propExpr);
        } else if (propExpr instanceof IntegerObjectInverseOf) {
            ret = ((IntegerObjectInverseOf)propExpr).getInverse();
        } else {
            throw new IllegalArgumentException("Object property expression cannot be translated: " + property);
        }
        return ret;
    }

    public IntegerObjectPropertyExpression visit(OWLObjectProperty owlObjectProperty) {
        Objects.requireNonNull(owlObjectProperty);
        this.getTranslationRepository().addObjectProperty(owlObjectProperty);
        return this.getDataTypeFactory().createObjectProperty(this.getTranslationRepository().getId(owlObjectProperty).intValue());
    }

    public IntegerObjectPropertyExpression visit(OWLAnnotationProperty owlAnnotationProperty) {
        Objects.requireNonNull(owlAnnotationProperty);
        return null;
    }
}

