/*
 * Decompiled with CFR 0.152.
 */
package de.tudresden.inf.lat.jcel.owlapi.translator;

import de.tudresden.inf.lat.jcel.ontology.axiom.complex.ComplexIntegerAxiom;
import de.tudresden.inf.lat.jcel.ontology.axiom.extension.IntegerOntologyObjectFactory;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClass;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerClassExpression;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerNamedIndividual;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectProperty;
import de.tudresden.inf.lat.jcel.ontology.datatype.IntegerObjectPropertyExpression;
import de.tudresden.inf.lat.jcel.owlapi.translator.AxiomTranslator;
import de.tudresden.inf.lat.jcel.owlapi.translator.ClassExpressionTranslator;
import de.tudresden.inf.lat.jcel.owlapi.translator.ObjectPropertyExpressionTranslator;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationException;
import de.tudresden.inf.lat.jcel.owlapi.translator.TranslationRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.NodeFactory;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLObjectPropertyNodeSet;

public class Translator {
    private final AxiomTranslator axiomTranslator;
    private final IntegerOntologyObjectFactory factory;

    public Translator(OWLDataFactory dataFactory, IntegerOntologyObjectFactory factory) {
        Objects.requireNonNull(dataFactory);
        Objects.requireNonNull(factory);
        TranslationRepository repository = new TranslationRepository(dataFactory, factory.getEntityManager());
        this.factory = factory;
        ObjectPropertyExpressionTranslator objPropExprTranslator = new ObjectPropertyExpressionTranslator(this.factory.getDataTypeFactory(), repository);
        ClassExpressionTranslator cet = new ClassExpressionTranslator(objPropExprTranslator);
        this.axiomTranslator = new AxiomTranslator(cet, this.factory);
    }

    public AxiomTranslator getAxiomTranslator() {
        return this.axiomTranslator;
    }

    public IntegerOntologyObjectFactory getOntologyObjectFactory() {
        return this.factory;
    }

    public TranslationRepository getTranslationRepository() {
        return this.axiomTranslator.getTranslationRepository();
    }

    public OWLClass translateC(IntegerClass integerObject) {
        Objects.requireNonNull(integerObject);
        return this.getTranslationRepository().getOWLClass(integerObject.getId());
    }

    public IntegerClass translateC(OWLClass owlObject) {
        Objects.requireNonNull(owlObject);
        return this.getOntologyObjectFactory().getDataTypeFactory().createClass(this.getAxiomTranslator().getTranslationRepository().getId(owlObject).intValue());
    }

    public IntegerClassExpression translateCE(OWLClassExpression owlObject) {
        Objects.requireNonNull(owlObject);
        return (IntegerClassExpression)owlObject.accept((OWLClassExpressionVisitorEx)this.getAxiomTranslator().getClassExpressionTranslator());
    }

    public OWLNamedIndividual translateI(IntegerNamedIndividual integerObject) {
        Objects.requireNonNull(integerObject);
        return this.getTranslationRepository().getOWLNamedIndividual(integerObject.getId());
    }

    public IntegerNamedIndividual translateI(OWLNamedIndividual owlObject) {
        Objects.requireNonNull(owlObject);
        return this.getOntologyObjectFactory().getDataTypeFactory().createNamedIndividual(this.getAxiomTranslator().getTranslationRepository().getId((OWLIndividual)owlObject).intValue());
    }

    public OWLObjectPropertyExpression translateOPE(IntegerObjectPropertyExpression integerObject) {
        Objects.requireNonNull(integerObject);
        if (!(integerObject instanceof IntegerObjectProperty)) {
            TranslationException.newUnsupportedTranslationException(integerObject);
        }
        IntegerObjectProperty property = (IntegerObjectProperty)integerObject;
        return this.getTranslationRepository().getOWLObjectProperty(property.getId());
    }

    public IntegerObjectPropertyExpression translateOPE(OWLObjectPropertyExpression owlObject) {
        Objects.requireNonNull(owlObject);
        return (IntegerObjectPropertyExpression)owlObject.accept((OWLPropertyExpressionVisitorEx)this.getAxiomTranslator().getClassExpressionTranslator().getObjectPropertyExpressionTranslator());
    }

    public Set<ComplexIntegerAxiom> translateSA(Set<OWLAxiom> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet<ComplexIntegerAxiom> ret = new HashSet<ComplexIntegerAxiom>();
        owlObject.forEach(axiom -> ret.addAll((Collection)axiom.accept((OWLAxiomVisitorEx)this.axiomTranslator)));
        return ret;
    }

    public Set<IntegerClass> translateSC(Node<OWLClass> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet ret = new HashSet();
        owlObject.forEach(cls -> ret.add(this.translateC((OWLClass)cls)));
        return Collections.unmodifiableSet(ret);
    }

    public Node<OWLClass> translateSC(Set<IntegerClass> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet set = new HashSet();
        integerObject.forEach(cls -> set.add(this.translateC((IntegerClass)cls)));
        return NodeFactory.getOWLClassNode(set);
    }

    public Set<IntegerNamedIndividual> translateSI(Node<OWLNamedIndividual> owlObject) {
        HashSet ret = new HashSet();
        owlObject.getEntities().forEach(indiv -> ret.add(this.translateI((OWLNamedIndividual)indiv)));
        return Collections.unmodifiableSet(ret);
    }

    public Node<OWLNamedIndividual> translateSI(Set<IntegerNamedIndividual> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet set = new HashSet();
        integerObject.forEach(indiv -> set.add(this.translateI((IntegerNamedIndividual)indiv)));
        return NodeFactory.getOWLNamedIndividualNode(set);
    }

    public Set<IntegerObjectPropertyExpression> translateSOPE(Node<OWLObjectPropertyExpression> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet ret = new HashSet();
        owlObject.getEntities().forEach(prop -> ret.add(this.translateOPE((OWLObjectPropertyExpression)prop)));
        return Collections.unmodifiableSet(ret);
    }

    public Node<OWLObjectPropertyExpression> translateSOPE(Set<IntegerObjectPropertyExpression> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet set = new HashSet();
        integerObject.forEach(prop -> set.add(this.translateOPE((IntegerObjectPropertyExpression)prop)));
        return NodeFactory.getOWLObjectPropertyNode(set);
    }

    public Set<Set<IntegerClass>> translateSSC(NodeSet<OWLClass> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet ret = new HashSet();
        owlObject.getNodes().forEach(node -> ret.add(this.translateSC((Node<OWLClass>)node)));
        return Collections.unmodifiableSet(ret);
    }

    public NodeSet<OWLClass> translateSSC(Set<Set<IntegerClass>> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet setOfNodes = new HashSet();
        integerObject.forEach(intSet -> setOfNodes.add(this.translateSC((Set<IntegerClass>)intSet)));
        return new OWLClassNodeSet(setOfNodes);
    }

    public Set<Set<IntegerNamedIndividual>> translateSSI(NodeSet<OWLNamedIndividual> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet ret = new HashSet();
        owlObject.getNodes().forEach(node -> ret.add(this.translateSI((Node<OWLNamedIndividual>)node)));
        return Collections.unmodifiableSet(ret);
    }

    public NodeSet<OWLNamedIndividual> translateSSI(Set<Set<IntegerNamedIndividual>> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet setOfNodes = new HashSet();
        integerObject.forEach(intSet -> setOfNodes.add(this.translateSI((Set<IntegerNamedIndividual>)intSet)));
        return new OWLNamedIndividualNodeSet(setOfNodes);
    }

    public Set<Set<IntegerObjectPropertyExpression>> translateSSOPE(NodeSet<OWLObjectPropertyExpression> owlObject) {
        Objects.requireNonNull(owlObject);
        HashSet ret = new HashSet();
        owlObject.getNodes().forEach(node -> ret.add(this.translateSOPE((Node<OWLObjectPropertyExpression>)node)));
        return Collections.unmodifiableSet(ret);
    }

    public NodeSet<OWLObjectPropertyExpression> translateSSOPE(Set<Set<IntegerObjectPropertyExpression>> integerObject) {
        Objects.requireNonNull(integerObject);
        HashSet setOfNodes = new HashSet();
        integerObject.forEach(intSet -> setOfNodes.add(this.translateSOPE((Set<IntegerObjectPropertyExpression>)intSet)));
        return new OWLObjectPropertyNodeSet(setOfNodes);
    }
}

