/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplPlain
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final String literal;
    @Nonnull
    private final String lang;

    public OWLLiteralImplPlain(@Nonnull String literal, @Nullable String lang) {
        this.literal = literal;
        this.lang = lang == null || lang.length() == 0 ? "" : lang;
        this.hashCode = this.getHashCode(literal);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)RDF_PLAIN_LITERAL);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    protected int index() {
        return 4008;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return !this.lang.equals("");
    }

    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isRDFPlainLiteral() {
        return true;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean parseBoolean() {
        throw new NumberFormatException(this.getClass().getName() + " does not have a boolean value");
    }

    public double parseDouble() {
        throw new NumberFormatException(this.getClass().getName() + " does not have a double value");
    }

    public float parseFloat() {
        throw new NumberFormatException(this.getClass().getName() + " does not have a float value");
    }

    public String getLang() {
        return this.lang;
    }

    public boolean hasLang(String l) {
        if (l == null) {
            return this.lang.isEmpty();
        }
        return this.lang.equalsIgnoreCase(l.trim());
    }

    public OWLDatatype getDatatype() {
        return RDF_PLAIN_LITERAL;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode(String lit) {
        int code = 277;
        code = code * 37 + RDF_PLAIN_LITERAL.hashCode();
        code = code * 37 + lit.hashCode() * 65536;
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        if (other instanceof OWLLiteralImplPlain) {
            return this.literal.equals(((OWLLiteralImplPlain)other).literal) && this.lang.equals(other.getLang());
        }
        return this.getLiteral().equals(other.getLiteral()) && (this.getDatatype().equals(other.getDatatype()) || OWL2Datatype.XSD_STRING.getIRI().equals((Object)other.getDatatype().getIRI()) || OWLRDFVocabulary.RDF_LANG_STRING.getIRI().equals((Object)other.getDatatype().getIRI())) && this.lang.equals(other.getLang());
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getDatatype().compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        return this.lang.compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

