/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.consistency;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.ReasonerComputation;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationFactory;
import org.semanticweb.elk.reasoner.saturation.ClassExpressionSaturationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationJob;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;
import org.semanticweb.elk.util.concurrent.computation.Interrupter;

public class ConsistencyChecking
extends ReasonerComputation<SaturationJob<IndexedClassEntity>, ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>>> {
    private static final Logger LOGGER_ = Logger.getLogger(ConsistencyChecking.class);
    private final ConsistencyMonitor consistencyMonitor_;

    ConsistencyChecking(Collection<SaturationJob<IndexedClassEntity>> inputJobs, ConsistencyMonitor consistencyMonitor, ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>> saturationFactory, ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        super(inputJobs, saturationFactory, executor, maxWorkers, progressMonitor);
        this.consistencyMonitor_ = consistencyMonitor;
    }

    public ConsistencyChecking(Collection<IndexedClassEntity> inputEntities, ConsistencyMonitor consistencyMonitor, SaturationState saturationState, ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        this(new TodoJobs(inputEntities, consistencyMonitor), consistencyMonitor, new ClassExpressionSaturationFactory<SaturationJob<IndexedClassEntity>>(saturationState, maxWorkers, new ThisClassExpressionSaturationListener(consistencyMonitor)), executor, maxWorkers, progressMonitor);
    }

    public SaturationStatistics getRuleAndConclusionStatistics() {
        return ((ClassExpressionSaturationFactory)this.getInputProcessorFactory()).getRuleAndConclusionStatistics();
    }

    public static Collection<IndexedClassEntity> getTestEntities(final OntologyIndex ontologyIndex) {
        if (!ontologyIndex.getIndexedOwlNothing().occursPositively()) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)"owl:Nothing does not occur positively; ontology is consistent");
            }
            return Collections.emptySet();
        }
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)"owl:Nothing occurs positively");
        }
        return new AbstractCollection<IndexedClassEntity>(){

            @Override
            public Iterator<IndexedClassEntity> iterator() {
                return Operations.concat((Iterable)Operations.singleton((Object)ontologyIndex.getIndexedOwlThing()), ontologyIndex.getIndexedIndividuals()).iterator();
            }

            @Override
            public int size() {
                return ontologyIndex.getIndexedIndividuals().size() + 1;
            }
        };
    }

    public ConsistencyChecking(ComputationExecutor executor, int maxWorkers, ProgressMonitor progressMonitor, OntologyIndex ontologyIndex, SaturationState saturationState) {
        this(ConsistencyChecking.getTestEntities(ontologyIndex), new ConsistencyMonitor(), saturationState, executor, maxWorkers, progressMonitor);
    }

    @Override
    public void process() {
        this.consistencyMonitor_.registerInterrupt((Interrupter)this);
        super.process();
        this.consistencyMonitor_.clearComputationToInterrupt();
    }

    public boolean isInconsistent() {
        return this.consistencyMonitor_.isInconsistent();
    }

    public void printStatistics() {
        ((ClassExpressionSaturationFactory)this.getInputProcessorFactory()).printStatistics();
    }

    static class TodoJobs
    extends AbstractCollection<SaturationJob<IndexedClassEntity>>
    implements Collection<SaturationJob<IndexedClassEntity>> {
        private final Collection<IndexedClassEntity> inputs;
        private final ConsistencyMonitor consistencyMonitor;

        TodoJobs(Collection<IndexedClassEntity> inputs, ConsistencyMonitor consistenceMonitor) {
            this.inputs = inputs;
            this.consistencyMonitor = consistenceMonitor;
        }

        @Override
        public int size() {
            return this.inputs.size();
        }

        @Override
        public Iterator<SaturationJob<IndexedClassEntity>> iterator() {
            return new Iterator<SaturationJob<IndexedClassEntity>>(){
                final Iterator<IndexedClassEntity> inputsIterator;
                boolean inconsistent;
                {
                    this.inputsIterator = TodoJobs.this.inputs.iterator();
                    this.inconsistent = false;
                }

                @Override
                public boolean hasNext() {
                    this.inconsistent = TodoJobs.this.consistencyMonitor.isInconsistent();
                    if (this.inconsistent) {
                        return false;
                    }
                    return this.inputsIterator.hasNext();
                }

                @Override
                public SaturationJob<IndexedClassEntity> next() {
                    if (this.inconsistent) {
                        throw new NoSuchElementException();
                    }
                    SaturationJob<IndexedClassExpression> job = new SaturationJob<IndexedClassExpression>(this.inputsIterator.next());
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(job.getInput() + ": consistency checking submitted"));
                    }
                    this.inconsistent = TodoJobs.this.consistencyMonitor.isInconsistent();
                    return job;
                }

                @Override
                public void remove() {
                    this.inputsIterator.remove();
                }
            };
        }
    }

    static class ConsistencyMonitor {
        private volatile boolean inconsistent_ = false;
        private volatile Interrupter interrupter_;

        ConsistencyMonitor() {
        }

        public void registerInterrupt(Interrupter computation) {
            this.interrupter_ = computation;
        }

        public void clearComputationToInterrupt() {
            this.interrupter_ = null;
        }

        public boolean isInconsistent() {
            return this.inconsistent_;
        }

        public void setInconsistent() {
            this.inconsistent_ = true;
            if (this.interrupter_ != null) {
                this.interrupter_.setInterrupt(true);
            } else {
                LOGGER_.error((Object)"no interrupter registered!");
            }
        }
    }

    private static class ThisClassExpressionSaturationListener
    implements ClassExpressionSaturationListener<SaturationJob<IndexedClassEntity>> {
        private final ConsistencyMonitor consistenceMonitor;

        ThisClassExpressionSaturationListener(ConsistencyMonitor consistenceMonitor) {
            this.consistenceMonitor = consistenceMonitor;
        }

        public void notifyFinished(SaturationJob<IndexedClassEntity> job) {
            if (((Context)job.getOutput()).isInconsistent()) {
                this.consistenceMonitor.setInconsistent();
            }
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(job.getInput() + ": consistency checking finished: " + (((Context)job.getOutput()).isInconsistent() ? "inconsistent" : "satisfiable")));
            }
        }
    }
}

