/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedAxiomVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.DisjointnessAxiom;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class IndexedDisjointnessAxiom
extends IndexedAxiom {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedDisjointnessAxiom.class);
    private final Set<IndexedClassExpression> inconsistentMembers_ = new ArrayHashSet(1);
    private final Set<IndexedClassExpression> disjointMembers_ = new ArrayHashSet(2);
    int occurrenceNo = 0;

    IndexedDisjointnessAxiom(List<IndexedClassExpression> members) {
        for (IndexedClassExpression member : members) {
            if (this.inconsistentMembers_.contains(member) || this.disjointMembers_.add(member)) continue;
            this.disjointMembers_.remove(member);
            this.inconsistentMembers_.add(member);
        }
    }

    public Set<IndexedClassExpression> getInconsistentMembers() {
        return this.inconsistentMembers_;
    }

    public Set<IndexedClassExpression> getDisjointMembers() {
        return this.disjointMembers_;
    }

    @Override
    public boolean occurs() {
        return this.occurrenceNo > 0;
    }

    @Override
    protected void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment) {
        if (this.occurrenceNo == 0 && increment > 0) {
            this.registerCompositionRule(index);
        }
        this.occurrenceNo += increment;
        if (this.occurrenceNo == 0 && increment < 0) {
            this.deregisterCompositionRule(index);
        }
    }

    @Override
    public <O> O accept(IndexedAxiomVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toStringStructural() {
        LinkedList<IndexedClassExpression> members = new LinkedList<IndexedClassExpression>();
        for (IndexedClassExpression inconsistentMember : this.inconsistentMembers_) {
            members.add(inconsistentMember);
            members.add(inconsistentMember);
        }
        members.addAll(this.disjointMembers_);
        return "DisjointClasses(" + members + ")";
    }

    private void registerCompositionRule(ModifiableOntologyIndex index) {
        for (IndexedClassExpression ice : this.inconsistentMembers_) {
            index.add(ice, new ThisContradictionRule());
        }
        for (IndexedClassExpression ice : this.disjointMembers_) {
            index.add(ice, new ThisCompositionRule(this));
        }
    }

    private void deregisterCompositionRule(ModifiableOntologyIndex index) {
        for (IndexedClassExpression ice : this.inconsistentMembers_) {
            index.remove(ice, new ThisContradictionRule());
        }
        for (IndexedClassExpression ice : this.disjointMembers_) {
            index.remove(ice, new ThisCompositionRule(this));
        }
    }

    public static class ThisContradictionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        public static final String NAME = "DisjointClasses Contradiction Introduction";
        private int contradictionCounter_ = 0;
        private static Matcher<ChainableRule<Context>, ThisContradictionRule> MATCHER_ = new SimpleTypeBasedMatcher(ThisContradictionRule.class);
        private static ReferenceFactory<ChainableRule<Context>, ThisContradictionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisContradictionRule>(){

            public ThisContradictionRule create(ChainableRule<Context> tail) {
                return new ThisContradictionRule(tail);
            }
        };

        public ThisContradictionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisContradictionRule() {
            this(null);
            ++this.contradictionCounter_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying DisjointClasses Contradiction Introduction to " + context));
            }
            writer.produce(context, Contradiction.getInstance());
        }

        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisContradictionRule rule = (ThisContradictionRule)ruleChain.getCreate(MATCHER_, FACTORY_);
            rule.contradictionCounter_ += this.contradictionCounter_;
            return this.contradictionCounter_ != 0;
        }

        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisContradictionRule rule = (ThisContradictionRule)ruleChain.find(MATCHER_);
            if (rule == null) {
                return false;
            }
            rule.contradictionCounter_ -= this.contradictionCounter_;
            if (rule.isEmpty()) {
                ruleChain.remove(MATCHER_);
            }
            return this.contradictionCounter_ != 0;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        protected boolean isEmpty() {
            return this.contradictionCounter_ == 0;
        }
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        public static final String NAME = "DisjointClasses Introduction";
        private final Set<IndexedDisjointnessAxiom> disjointnessAxioms_ = new ArrayHashSet();
        private static Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher(ThisCompositionRule.class);
        private static ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            public ThisCompositionRule create(ChainableRule<Context> tail) {
                return new ThisCompositionRule(tail);
            }
        };

        private ThisCompositionRule(ChainableRule<Context> tail) {
            super(tail);
        }

        ThisCompositionRule(IndexedDisjointnessAxiom axiom) {
            this((ChainableRule<Context>)null);
            this.disjointnessAxioms_.add(axiom);
        }

        public Set<IndexedDisjointnessAxiom> getDisjointnessAxioms() {
            return this.disjointnessAxioms_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("Applying DisjointClasses Introduction to " + context));
            }
            for (IndexedDisjointnessAxiom disAxiom : this.disjointnessAxioms_) {
                writer.produce(context, new DisjointnessAxiom(disAxiom));
            }
        }

        protected boolean isEmpty() {
            return this.disjointnessAxioms_.isEmpty();
        }

        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = (ThisCompositionRule)ruleChain.getCreate(MATCHER_, FACTORY_);
            return rule.disjointnessAxioms_.addAll(this.disjointnessAxioms_);
        }

        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = (ThisCompositionRule)ruleChain.find(MATCHER_);
            boolean changed = false;
            if (rule != null) {
                changed = rule.disjointnessAxioms_.removeAll(this.disjointnessAxioms_);
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                }
            }
            return changed;
        }
    }
}

