/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextImpl;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.CombinedConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionInsertionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionOccurranceCheckingVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionStatistics;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.conclusions.Contradiction;
import org.semanticweb.elk.reasoner.saturation.conclusions.DisjointnessAxiom;
import org.semanticweb.elk.reasoner.saturation.conclusions.ForwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.PositiveSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.Propagation;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.BasicCompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.BasicDecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationFactory;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleStatistics;

public class ContextCompletionFactory
extends RuleApplicationFactory {
    protected static final Logger LOGGER_ = Logger.getLogger(ContextCompletionFactory.class);
    private final LocalSaturationState localState_;

    public ContextCompletionFactory(SaturationState saturationState) {
        super(saturationState);
        this.localState_ = new LocalSaturationState(saturationState.getOntologyIndex());
    }

    @Override
    public RuleApplicationFactory.BaseEngine getDefaultEngine(ContextCreationListener listener, ContextModificationListener modListener) {
        return new ContextCompletionEngine();
    }

    @Override
    public SaturationState getSaturationState() {
        return this.localState_;
    }

    private static class ConclusionGapFillingVisitor
    implements ConclusionVisitor<Boolean> {
        private final BasicSaturationStateWriter iterationWriter_;
        private final RuleApplicationVisitor ruleAppVisitor_;
        private final DecompositionRuleApplicationVisitor iterateDecompRuleAppVisitor_;
        private final DecompositionRuleApplicationVisitor produceDecompRuleAppVisitor_;

        public ConclusionGapFillingVisitor(BasicSaturationStateWriter enumWriter, RuleApplicationVisitor ruleAppVisitor, DecompositionRuleApplicationVisitor enumVisitor, DecompositionRuleApplicationVisitor produceVisitor) {
            this.iterationWriter_ = enumWriter;
            this.ruleAppVisitor_ = ruleAppVisitor;
            this.iterateDecompRuleAppVisitor_ = enumVisitor;
            this.produceDecompRuleAppVisitor_ = produceVisitor;
        }

        @Override
        public Boolean visit(NegativeSubsumer negSCE, Context context) {
            negSCE.apply(this.iterationWriter_, context.getRoot().getContext(), this.ruleAppVisitor_);
            negSCE.applyDecompositionRules(context.getRoot().getContext(), this.produceDecompRuleAppVisitor_);
            return true;
        }

        @Override
        public Boolean visit(PositiveSubsumer posSCE, Context context) {
            posSCE.apply(this.iterationWriter_, context.getRoot().getContext(), this.ruleAppVisitor_, this.iterateDecompRuleAppVisitor_);
            return true;
        }

        @Override
        public Boolean visit(BackwardLink link, Context context) {
            link.apply(this.iterationWriter_, context.getRoot().getContext(), this.ruleAppVisitor_);
            return true;
        }

        @Override
        public Boolean visit(ForwardLink link, Context context) {
            link.apply(this.iterationWriter_, context.getRoot().getContext());
            return true;
        }

        @Override
        public Boolean visit(Contradiction bot, Context context) {
            bot.deapply(this.iterationWriter_, context.getRoot().getContext());
            return true;
        }

        @Override
        public Boolean visit(Propagation propagation, Context context) {
            propagation.apply(this.iterationWriter_, context.getRoot().getContext());
            return true;
        }

        @Override
        public Boolean visit(DisjointnessAxiom disjointnessAxiom, Context context) {
            disjointnessAxiom.apply(this.iterationWriter_, context.getRoot().getContext());
            return true;
        }
    }

    private static class GapFillingDecompositionVisitor
    extends BasicDecompositionRuleApplicationVisitor {
        private final BasicSaturationStateWriter localWriter_;
        private final ExtendedSaturationStateWriter mainWriter_;

        GapFillingDecompositionVisitor(BasicSaturationStateWriter localWriter, ExtendedSaturationStateWriter mainWriter) {
            this.localWriter_ = localWriter;
            this.mainWriter_ = mainWriter;
        }

        @Override
        public void visit(IndexedObjectSomeValuesFrom ice, Context context) {
            Context fillerContext = this.mainWriter_.getCreateContext(ice.getFiller());
            this.localWriter_.produce(fillerContext, new BackwardLink(context, ice.getRelation()));
        }

        @Override
        protected BasicSaturationStateWriter getSaturationStateWriter() {
            return this.localWriter_;
        }
    }

    private class LocalSaturationState
    implements SaturationState {
        private final ConcurrentHashMap<IndexedClassExpression, Context> contextMap_;
        private final OntologyIndex ontologyIndex_;
        private final Queue<Context> activeContexts_ = new ConcurrentLinkedQueue<Context>();

        LocalSaturationState(OntologyIndex index) {
            this.contextMap_ = new ConcurrentHashMap();
            this.ontologyIndex_ = index;
        }

        @Override
        public OntologyIndex getOntologyIndex() {
            return this.ontologyIndex_;
        }

        @Override
        public Context getContext(IndexedClassExpression ice) {
            return this.contextMap_.get(ice);
        }

        @Override
        public Collection<Context> getContexts() {
            return this.contextMap_.values();
        }

        @Override
        public Collection<IndexedClassExpression> getNotSaturatedContexts() {
            return this.contextMap_.keySet();
        }

        @Override
        public ExtendedSaturationStateWriter getExtendedWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener, RuleApplicationVisitor ruleAppVisitor, ConclusionVisitor<?> conclusionVisitor, boolean trackNewContextsAsUnsaturated) {
            return new IterationSaturationStateWriter(conclusionVisitor, ruleAppVisitor, ContextCompletionFactory.this.saturationState.getExtendedWriter(contextCreationListener, contextModificationListener, ruleAppVisitor, conclusionVisitor, trackNewContextsAsUnsaturated));
        }

        @Override
        public BasicSaturationStateWriter getWriter(ContextModificationListener contextModificationListener, ConclusionVisitor<?> conclusionVisitor) {
            return this.getDefaultWriter(conclusionVisitor);
        }

        @Override
        public BasicSaturationStateWriter getWriter(ConclusionVisitor<?> conclusionVisitor) {
            return this.getDefaultWriter(conclusionVisitor);
        }

        @Override
        public ExtendedSaturationStateWriter getExtendedWriter(ConclusionVisitor<?> conclusionVisitor) {
            return this.getDefaultWriter(conclusionVisitor);
        }

        private IterationSaturationStateWriter getDefaultWriter(ConclusionVisitor<?> conclusionVisitor) {
            return new IterationSaturationStateWriter(conclusionVisitor, new BasicCompositionRuleApplicationVisitor(), ContextCompletionFactory.this.saturationState.getExtendedWriter(conclusionVisitor));
        }

        private ExtendedSaturationStateWriter getWriterForDecompositionVisitor(ConclusionVisitor<?> conclusionVisitor, RuleApplicationVisitor initRuleAppVisitor) {
            return new OptimizedLocalSaturationStateWriter(conclusionVisitor, initRuleAppVisitor);
        }

        private class IterationSaturationStateWriter
        extends OptimizedLocalSaturationStateWriter {
            private final ExtendedSaturationStateWriter mainStateWriter_;

            IterationSaturationStateWriter(ConclusionVisitor<?> visitor, RuleApplicationVisitor ruleAppVisitor, ExtendedSaturationStateWriter writer) {
                super(visitor, ruleAppVisitor);
                this.mainStateWriter_ = writer;
            }

            @Override
            public IndexedClassExpression getOwlThing() {
                return LocalSaturationState.this.ontologyIndex_.getIndexedOwlThing();
            }

            @Override
            public IndexedClassExpression getOwlNothing() {
                return LocalSaturationState.this.ontologyIndex_.getIndexedOwlNothing();
            }

            @Override
            public Context pollForActiveContext() {
                return (Context)LocalSaturationState.this.activeContexts_.poll();
            }

            void produceGlobally(Context context, Conclusion conclusion) {
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)(context + ": conclusion " + conclusion + " does NOT exist in the main context, insert into TODO"));
                }
                this.mainStateWriter_.produce(context.getRoot().getContext(), conclusion);
            }

            @Override
            public void produce(Context context, Conclusion conclusion) {
                if (this.existsGlobally(context, conclusion)) {
                    Context sourceContext = conclusion.getSourceContext(context);
                    if (sourceContext == null || !sourceContext.isSaturated()) {
                        this.produceLocally(context, conclusion);
                    }
                } else {
                    this.produceGlobally(context, conclusion);
                }
            }
        }

        private class OptimizedLocalSaturationStateWriter
        implements ExtendedSaturationStateWriter {
            private final RuleApplicationVisitor initRuleAppVisitor_;
            private final ConclusionVisitor<?> conclusionVisitor_;
            private final ConclusionVisitor<Boolean> checker_;

            OptimizedLocalSaturationStateWriter(ConclusionVisitor<?> visitor, RuleApplicationVisitor ruleAppVisitor) {
                this.conclusionVisitor_ = visitor;
                this.checker_ = new ConclusionOccurranceCheckingVisitor();
                this.initRuleAppVisitor_ = ruleAppVisitor;
            }

            @Override
            public IndexedClassExpression getOwlThing() {
                return LocalSaturationState.this.ontologyIndex_.getIndexedOwlThing();
            }

            @Override
            public IndexedClassExpression getOwlNothing() {
                return LocalSaturationState.this.ontologyIndex_.getIndexedOwlNothing();
            }

            @Override
            public Context pollForActiveContext() {
                return (Context)LocalSaturationState.this.activeContexts_.poll();
            }

            boolean existsGlobally(Context context, Conclusion conclusion) {
                return conclusion.accept(this.checker_, context.getRoot().getContext());
            }

            void produceLocally(Context context, Conclusion conclusion) {
                Context localContext = LocalSaturationState.this.getContext(context.getRoot());
                if (localContext == null) {
                    localContext = this.getCreateContext(context.getRoot());
                }
                conclusion.accept(this.conclusionVisitor_, localContext);
                if (localContext.addToDo(conclusion)) {
                    LocalSaturationState.this.activeContexts_.add(localContext);
                }
            }

            @Override
            public void produce(Context context, Conclusion conclusion) {
                if (this.existsGlobally(context, conclusion)) {
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(context + ": conclusion " + conclusion + " exists in the main context, producing locally"));
                    }
                    this.produceLocally(context, conclusion);
                }
            }

            @Override
            public boolean markAsNotSaturated(Context context) {
                return false;
            }

            @Override
            public void clearNotSaturatedContexts() {
            }

            @Override
            public void resetContexts() {
                LocalSaturationState.this.contextMap_.clear();
            }

            @Override
            public Context getCreateContext(IndexedClassExpression root) {
                ContextImpl context = new ContextImpl(root);
                Context oldContext = LocalSaturationState.this.contextMap_.putIfAbsent(root, context);
                if (oldContext == null) {
                    this.initContext(context);
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace((Object)(context.getRoot() + ": local context created"));
                    }
                    return context;
                }
                return oldContext;
            }

            @Override
            public void initContext(Context context) {
                SaturationUtils.initContext(context, this, LocalSaturationState.this.ontologyIndex_, this.initRuleAppVisitor_);
            }

            @Override
            public void removeContext(Context context) {
                LocalSaturationState.this.contextMap_.remove(context.getRoot());
            }
        }
    }

    private class ContextCompletionEngine
    extends RuleApplicationFactory.BaseEngine {
        private RuleApplicationVisitor initRuleAppVisitor_;
        private ExtendedSaturationStateWriter iterationWriter_;
        private ExtendedSaturationStateWriter mainStateWriter_;
        private ConclusionVisitor<?> conclusionStatsVisitor_;

        protected ContextCompletionEngine() {
            super(ContextCompletionFactory.this, new SaturationStatistics());
        }

        public void submit(IndexedClassExpression root) {
            this.getSaturationStateWriter().getCreateContext(root);
        }

        @Override
        protected ExtendedSaturationStateWriter getSaturationStateWriter() {
            if (this.iterationWriter_ == null) {
                ConclusionStatistics stats = this.localStatistics.getConclusionStatistics();
                this.initRuleAppVisitor_ = SaturationUtils.getStatsAwareCompositionRuleAppVisitor(this.localStatistics.getRuleStatistics());
                this.conclusionStatsVisitor_ = SaturationUtils.addStatsToConclusionVisitor(stats);
                this.iterationWriter_ = ContextCompletionFactory.this.localState_.getExtendedWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY, this.initRuleAppVisitor_, this.conclusionStatsVisitor_, false);
                this.mainStateWriter_ = ContextCompletionFactory.this.saturationState.getExtendedWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY, this.initRuleAppVisitor_, this.conclusionStatsVisitor_, true);
            }
            return this.iterationWriter_;
        }

        @Override
        protected DecompositionRuleApplicationVisitor getDecompositionRuleApplicationVisitor() {
            return null;
        }

        @Override
        protected ConclusionVisitor<Boolean> getBaseConclusionProcessor(BasicSaturationStateWriter saturationStateWriter) {
            RuleStatistics ruleStats = this.localStatistics.getRuleStatistics();
            DecompositionRuleApplicationVisitor iterationVisitor = SaturationUtils.getStatsAwareDecompositionRuleAppVisitor(new GapFillingDecompositionVisitor(this.iterationWriter_, this.mainStateWriter_), ruleStats);
            DecompositionRuleApplicationVisitor produceVisitor = SaturationUtils.getStatsAwareDecompositionRuleAppVisitor(new GapFillingDecompositionVisitor(ContextCompletionFactory.this.localState_.getWriterForDecompositionVisitor(this.conclusionStatsVisitor_, this.initRuleAppVisitor_), this.mainStateWriter_), ruleStats);
            ConclusionGapFillingVisitor gapFiller = new ConclusionGapFillingVisitor(saturationStateWriter, SaturationUtils.getStatsAwareCompositionRuleAppVisitor(this.localStatistics.getRuleStatistics()), iterationVisitor, produceVisitor);
            return new CombinedConclusionVisitor(new ConclusionInsertionVisitor(), this.getUsedConclusionsCountingVisitor(gapFiller));
        }
    }
}

