/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.adapters.AdapterLib;
import org.apache.jena.riot.adapters.AdapterLocationMapper;
import org.apache.jena.riot.adapters.FileManagerModelCache;
import org.apache.jena.riot.system.stream.LocationMapper;
import org.apache.jena.riot.system.stream.Locator;
import org.apache.jena.riot.system.stream.LocatorClassLoader;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorFile;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.LocatorZip;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.shared.NotFoundException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.FileUtils;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdapterFileManager
implements FileManager {
    private static Logger log = LoggerFactory.getLogger(AdapterFileManager.class);
    private static AdapterFileManager instance = null;
    private final StreamManager streamManager;
    private FileManagerModelCache modelCache = new FileManagerModelCache();

    public static AdapterFileManager get() {
        if (instance == null) {
            instance = AdapterFileManager.makeGlobal();
        }
        return instance;
    }

    public static void setGlobalFileManager(AdapterFileManager globalFileManager) {
        instance = globalFileManager;
    }

    private AdapterFileManager() {
        this.streamManager = new StreamManager();
    }

    public FileManager clone() {
        StreamManager sm = this.streamManager.clone();
        AdapterFileManager x = new AdapterFileManager(sm);
        return x;
    }

    public AdapterFileManager(StreamManager streamManager) {
        this(streamManager, streamManager == null ? null : streamManager.getLocationMapper());
    }

    public AdapterFileManager(StreamManager streamManager, LocationMapper mapper) {
        if (streamManager == null) {
            streamManager = new StreamManager();
        }
        this.streamManager = streamManager;
        streamManager.setLocationMapper(mapper);
    }

    public static AdapterFileManager makeGlobal() {
        AdapterFileManager fMgr = new AdapterFileManager(StreamManager.get());
        return fMgr;
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    public void setLocationMapper(org.apache.jena.util.LocationMapper mapper) {
        this.streamManager.setLocationMapper(AdapterLib.copyConvert(mapper));
    }

    public org.apache.jena.util.LocationMapper getLocationMapper() {
        return new AdapterLocationMapper(this.streamManager.getLocationMapper());
    }

    public Iterator<org.apache.jena.util.Locator> locators() {
        throw new UnsupportedOperationException();
    }

    public void remove(org.apache.jena.util.Locator loc) {
        throw new UnsupportedOperationException();
    }

    public void addLocator(org.apache.jena.util.Locator oldloc) {
        Locator loc = AdapterLib.convert(oldloc);
        log.debug("Add location: " + loc.getName());
        this.streamManager.addLocator(loc);
    }

    public void addLocatorFile() {
        this.addLocatorFile(null);
    }

    public void addLocatorFile(String dir) {
        LocatorFile fLoc = new LocatorFile(dir);
        this.streamManager.addLocator(fLoc);
    }

    public void addLocatorClassLoader(ClassLoader cLoad) {
        LocatorClassLoader cLoc = new LocatorClassLoader(cLoad);
        this.streamManager.addLocator(cLoc);
    }

    public void addLocatorURL() {
        this.addLocatorHTTP();
    }

    public void addLocatorHTTP() {
        LocatorHTTP loc = new LocatorHTTP();
        this.streamManager.addLocator(loc);
    }

    public void addLocatorFTP() {
        LocatorFTP loc = new LocatorFTP();
        this.streamManager.addLocator(loc);
    }

    public void addLocatorZip(String zfn) {
        LocatorZip loc = new LocatorZip(zfn);
        this.streamManager.addLocator(loc);
    }

    public void resetCache() {
        this.modelCache.resetCache();
    }

    public void setModelCaching(boolean state) {
        this.modelCache.setModelCaching(state);
    }

    public boolean isCachingModels() {
        return this.modelCache.isCachingModels();
    }

    public Model getFromCache(String filenameOrURI) {
        return this.modelCache.getFromCache(filenameOrURI);
    }

    public boolean hasCachedModel(String filenameOrURI) {
        return this.modelCache.hasCachedModel(filenameOrURI);
    }

    public void addCacheModel(String uri, Model m) {
        this.modelCache.addCacheModel(uri, m);
    }

    public void removeCacheModel(String uri) {
        this.modelCache.removeCacheModel(uri);
    }

    protected Model readModelWorker(Model model, String filenameOrURI, String baseURI, String syntax) {
        Lang lang;
        String mappedURI = this.mapURI(filenameOrURI);
        if (log.isDebugEnabled() && !mappedURI.equals(filenameOrURI)) {
            log.debug("Map: " + filenameOrURI + " => " + mappedURI);
        }
        Lang lang2 = lang = syntax != null ? RDFLanguages.nameToLang(syntax) : RDFLanguages.resourceNameToLang(mappedURI, Lang.RDFXML);
        if (baseURI == null) {
            baseURI = SysRIOT.chooseBaseIRI(filenameOrURI);
        }
        try (TypedInputStream in = this.streamManager.openNoMapOrNull(mappedURI);){
            if (in == null) {
                FmtLog.debug((Logger)log, (String)"Failed to locate '%s'", (Object[])new Object[]{mappedURI});
                throw new NotFoundException("Not found: " + filenameOrURI);
            }
            Lang lang22 = RDFDataMgr.determineLang(mappedURI, in.getContentType(), lang);
            model.read((InputStream)in, baseURI, lang22.getName());
        }
        return model;
    }

    public InputStream open(String filenameOrURI) {
        return this.streamManager.open(filenameOrURI);
    }

    public String mapURI(String filenameOrURI) {
        return this.streamManager.mapURI(filenameOrURI);
    }

    public InputStream openNoMap(String filenameOrURI) {
        return this.streamManager.openNoMap(filenameOrURI);
    }

    public TypedStream openNoMapOrNull(String filenameOrURI) {
        return AdapterLib.convert(this.streamManager.openNoMapOrNull(filenameOrURI));
    }

    public Model loadModelInternal(String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, null);
    }

    @Deprecated
    public Model loadModel(String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, null, rdfSyntax);
    }

    @Deprecated
    public Model loadModel(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("loadModel(" + filenameOrURI + ", " + baseURI + ", " + rdfSyntax + ")");
        }
        return this.loadModelWorker(filenameOrURI, baseURI, rdfSyntax);
    }

    private Model loadModelWorker(String filenameOrURI, String baseURI, String rdfSyntax) {
        if (this.hasCachedModel(filenameOrURI)) {
            if (log.isDebugEnabled()) {
                log.debug("Model cache hit: " + filenameOrURI);
            }
            return this.getFromCache(filenameOrURI);
        }
        Model m = ModelFactory.createDefaultModel();
        this.readModelWorker(m, filenameOrURI, baseURI, rdfSyntax);
        if (this.isCachingModels()) {
            this.addCacheModel(filenameOrURI, m);
        }
        return m;
    }

    public Model readModelInternal(Model model, String filenameOrURI) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ")");
        }
        return this.readModel(model, filenameOrURI, null);
    }

    @Deprecated
    public Model readModel(Model model, String filenameOrURI, String rdfSyntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + rdfSyntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, null, rdfSyntax);
    }

    @Deprecated
    public Model readModel(Model model, String filenameOrURI, String baseURI, String syntax) {
        if (log.isDebugEnabled()) {
            log.debug("readModel(model," + filenameOrURI + ", " + baseURI + ", " + syntax + ")");
        }
        return this.readModelWorker(model, filenameOrURI, baseURI, syntax);
    }

    private static String chooseBaseURI(String baseURI) {
        String scheme = FileUtils.getScheme((String)baseURI);
        if (scheme != null) {
            if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
                try {
                    String tmp = baseURI.substring("file:".length());
                    File f = new File(tmp);
                    baseURI = "file:///" + f.getCanonicalPath();
                    baseURI = baseURI.replace('\\', '/');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return baseURI;
        }
        if (baseURI.startsWith("/")) {
            return "file://" + baseURI;
        }
        return "file:" + baseURI;
    }

    @Deprecated
    public String readWholeFileAsUTF8(InputStream in) {
        return IO.readWholeFileAsUTF8((InputStream)in);
    }

    public String readWholeFileAsUTF8(String filename) {
        InputStream in = this.open(filename);
        if (in == null) {
            throw new NotFoundException("File not found: " + filename);
        }
        return this.readWholeFileAsUTF8(in);
    }
}

