/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecution;

public class EngineLib {
    public static void parseSetTimeout(QueryExecution qExec, String str2, TimeUnit unit, boolean merge) {
        if (str2 == null) {
            return;
        }
        try {
            if (str2.contains(",")) {
                String[] a = str2.split(",");
                if (a.length > 2) {
                    Log.warn((Object)qExec, (String)("Can't interpret string for timeout: " + str2));
                    throw new QueryBuildException();
                }
                long x1 = Long.parseLong(a[0]);
                x1 = unit.toMillis(x1);
                long x2 = Long.parseLong(a[1]);
                x2 = unit.toMillis(x2);
                if (merge) {
                    EngineLib.mergeTimeouts(qExec, x1, x2);
                } else {
                    qExec.setTimeout(x1, x2);
                }
            } else {
                long x = Long.parseLong(str2);
                x = unit.toMillis(x);
                if (merge) {
                    EngineLib.mergeTimeouts(qExec, -1L, x);
                } else {
                    qExec.setTimeout(x);
                }
            }
        }
        catch (RuntimeException ex) {
            Log.warn((Object)qExec, (String)("Can't interpret string for timeout: " + str2));
        }
    }

    private static void mergeTimeouts(QueryExecution qExec, long timeout1, long timeout2) {
        if (timeout1 >= 0L) {
            if (qExec.getTimeout1() != -1L) {
                timeout1 = Math.min(qExec.getTimeout1(), timeout1);
            }
        } else {
            timeout1 = qExec.getTimeout1();
        }
        if (timeout2 >= 0L) {
            if (qExec.getTimeout2() != -1L) {
                timeout2 = Math.min(qExec.getTimeout2(), timeout2);
            }
        } else {
            timeout2 = qExec.getTimeout2();
        }
        qExec.setTimeout(timeout1, timeout2);
    }
}

