/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.URI;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.graph.algo.accessor.GraphAccessor;
import slib.graph.algo.extraction.rvf.AncestorEngine;
import slib.graph.algo.extraction.rvf.DescendantEngine;
import slib.graph.algo.extraction.rvf.RVF_TAX;
import slib.graph.algo.metric.DepthAnalyserAG;
import slib.graph.algo.shortest_path.Dijkstra;
import slib.graph.algo.traversal.classical.DFS;
import slib.graph.algo.validator.dag.ValidatorDAG;
import slib.graph.model.graph.G;
import slib.graph.model.graph.elements.E;
import slib.graph.model.graph.utils.Direction;
import slib.graph.model.graph.utils.WalkConstraint;
import slib.graph.model.graph.weight.GWS;
import slib.graph.model.impl.graph.weight.GWS_impl;
import slib.graph.utils.WalkConstraintUtils;
import slib.sml.sm.core.engine.SMProxResultStorage;
import slib.sml.sm.core.measures.Sim_Groupwise_Direct;
import slib.sml.sm.core.measures.Sim_Groupwise_Indirect;
import slib.sml.sm.core.measures.Sim_Pairwise;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.metrics.ic.annot.ICcorpus;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Corpus;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.metrics.ic.utils.IcUtils;
import slib.sml.sm.core.metrics.vector.VectorWeight_Chabalier_2007;
import slib.sml.sm.core.utils.LCAFinder;
import slib.sml.sm.core.utils.LCAFinderImpl;
import slib.sml.sm.core.utils.SMconf;
import slib.sml.sm.core.utils.SMutils;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.MatrixDouble;
import slib.utils.impl.SetUtils;

public class SM_Engine {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    final G graph;
    AncestorEngine ancGetter;
    DescendantEngine descGetter;
    LCAFinder lcaFinder;
    Set<URI> classes;
    Set<URI> classesLeaves;
    Set<URI> instances;
    URI root = null;
    SMProxResultStorage cache;
    boolean cachePairwiseResults = false;
    Map<URI, Double> vectorWeights = null;
    Map<SMconf, Sim_Pairwise> pairwiseMeasures;
    Map<SMconf, Sim_Groupwise_Indirect> groupwiseAddOnMeasures;
    Map<SMconf, Sim_Groupwise_Direct> groupwiseStandaloneMeasures;

    public SM_Engine(G g) throws SLIB_Ex_Critic {
        this.graph = g;
        this.logger.info("================================================================");
        this.logger.info("Loading Semantic Measures Engine for graph " + this.graph.getURI());
        this.logger.info("================================================================");
        this.logger.info("Graph Info: ");
        this.logger.info(g.toString());
        this.ancGetter = new AncestorEngine(this.graph);
        this.descGetter = new DescendantEngine(this.graph);
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Pre-processing");
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Computing classes...");
        this.classes = GraphAccessor.getClasses((G)this.graph);
        this.logger.info("Computing instances...");
        this.instances = GraphAccessor.getInstances((G)this.graph);
        this.logger.info("Classes  : " + this.classes.size());
        this.logger.info("Instances: " + this.instances.size());
        this.cache = new SMProxResultStorage();
        this.pairwiseMeasures = new ConcurrentHashMap<SMconf, Sim_Pairwise>();
        this.groupwiseAddOnMeasures = new ConcurrentHashMap<SMconf, Sim_Groupwise_Indirect>();
        this.groupwiseStandaloneMeasures = new ConcurrentHashMap<SMconf, Sim_Groupwise_Direct>();
        this.lcaFinder = new LCAFinderImpl(this);
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Inferences ");
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Inferring ancestors...");
        this.computeAllclassesAncestors();
        this.logger.info("Inferring descendants...");
        this.computeAllclassesDescendants();
        this.logger.info("Inferring Conceptual Leaves...");
        this.computeLeaves();
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("Engine initialized");
        this.logger.info("================================================================");
    }

    private void computeAllclassesAncestors() throws SLIB_Ex_Critic {
        this.cache.ancestorsInc = this.ancGetter.getAllAncestorsInc();
    }

    private void computeAllclassesDescendants() throws SLIB_Ex_Critic {
        this.cache.descendantsInc = this.descGetter.getAllDescendantsInc();
    }

    public Set<URI> getAncestorsInc(Set<URI> setClasses) {
        this.throwErrorIfNotClass(setClasses);
        HashSet<URI> unionAnc = new HashSet<URI>();
        for (URI v : setClasses) {
            unionAnc.addAll(this.getAncestorsInc(v));
        }
        return unionAnc;
    }

    public Set<URI> getAncestorsInc(URI v) {
        this.throwErrorIfNotClass(v);
        return Collections.unmodifiableSet(this.cache.ancestorsInc.get(v));
    }

    public synchronized Set<URI> getDescendantsInc(URI v) {
        this.throwErrorIfNotClass(v);
        return Collections.unmodifiableSet(this.cache.descendantsInc.get(v));
    }

    public Set<URI> getParents(URI v) {
        this.throwErrorIfNotClass(v);
        Set parents = this.graph.getV(v, this.ancGetter.getWalkConstraint());
        return parents;
    }

    public Map<URI, Integer> getMaxDepths() throws SLIB_Ex_Critic {
        if (this.cache.maxDepths == null) {
            DepthAnalyserAG dephtAnalyser = new DepthAnalyserAG(this.graph, this.descGetter.getWalkConstraint());
            this.cache.maxDepths = dephtAnalyser.getVMaxDepths();
        }
        return Collections.unmodifiableMap(this.cache.maxDepths);
    }

    public Map<URI, Integer> getMinDepths() throws SLIB_Ex_Critic {
        if (this.cache.minDepths == null) {
            DepthAnalyserAG dephtAnalyser = new DepthAnalyserAG(this.graph, this.descGetter.getWalkConstraint());
            this.cache.minDepths = dephtAnalyser.getVMinDepths();
        }
        return Collections.unmodifiableMap(this.cache.minDepths);
    }

    public double getIC(ICconf icConf, URI v) throws SLIB_Exception {
        this.throwErrorIfNotClass(v);
        if (icConf == null) {
            throw new SLIB_Ex_Critic("Specified IC cannot be null");
        }
        if (!this.classes.contains(v)) {
            // empty if block
        }
        if (this.cache.metrics_results.get((Object)icConf) == null) {
            this.computeIC(icConf);
        }
        return this.cache.metrics_results.get((Object)icConf).get(v);
    }

    public int getMaxDepth() throws SLIB_Exception {
        if (this.cache.maxDepth == null) {
            this.cache.maxDepth = Collections.max(this.getMaxDepths().values());
        }
        return this.cache.maxDepth;
    }

    public synchronized URI getRoot() throws SLIB_Ex_Critic {
        if (this.root == null) {
            URI rooturi;
            this.root = rooturi = new ValidatorDAG().getUniqueTaxonomicRoot(this.graph);
        }
        return this.root;
    }

    public double getIC_MICA(ICconf icConf, URI a, URI b) throws SLIB_Exception {
        this.throwErrorIfNotClass(a);
        this.throwErrorIfNotClass(b);
        if (this.cache.metrics_results.get((Object)icConf) == null) {
            this.computeIC(icConf);
        }
        return IcUtils.searchMax_IC_MICA(a, b, this.getAncestorsInc(a), this.getAncestorsInc(b), this.getIC_results(icConf));
    }

    public URI getMICA(ICconf icConf, URI a, URI b) throws SLIB_Exception {
        this.throwErrorIfNotClass(a);
        this.throwErrorIfNotClass(b);
        if (this.cache.metrics_results.get((Object)icConf) == null) {
            this.computeIC(icConf);
        }
        return IcUtils.searchMICA(a, b, this.getAncestorsInc(a), this.getAncestorsInc(b), this.getIC_results(icConf));
    }

    public Map<URI, Integer> getAllNbDescendantsInc() throws SLIB_Ex_Critic {
        HashMap<URI, Integer> allNbDescendants = new HashMap<URI, Integer>();
        for (URI c : this.classes) {
            allNbDescendants.put(c, this.getAllDescendantsInc().get(c).size());
        }
        return allNbDescendants;
    }

    public Map<URI, Set<URI>> getAllDescendantsInc() throws SLIB_Ex_Critic {
        return Collections.unmodifiableMap(this.cache.descendantsInc);
    }

    public Map<URI, Set<URI>> getAllAncestorsInc() throws SLIB_Ex_Critic {
        return Collections.unmodifiableMap(this.cache.ancestorsInc);
    }

    public Map<URI, Double> getIC_results(ICconf icConf) throws SLIB_Ex_Critic {
        if (!this.cache.metrics_results.containsKey((Object)icConf)) {
            this.cache.metrics_results.put(icConf, this.computeIC(icConf));
        }
        return Collections.unmodifiableMap(this.cache.metrics_results.get((Object)icConf));
    }

    public synchronized Map<URI, Double> computeIC(ICconf icConf) throws SLIB_Ex_Critic {
        if (icConf == null) {
            throw new SLIB_Ex_Critic("IC configuration cannot be set to null... " + (Object)((Object)icConf));
        }
        if (this.cache.metrics_results.get((Object)icConf) != null) {
            return Collections.unmodifiableMap(this.cache.metrics_results.get((Object)icConf));
        }
        this.logger.info("---------------------------------------------------------------");
        this.logger.info("computing IC " + icConf.getId());
        this.logger.info("---------------------------------------------------------------");
        try {
            Map<URI, Double> results;
            Object o;
            Constructor<?> co;
            Class<?> cl;
            String icClassName = icConf.getClassName();
            this.logger.info("Class name " + icClassName);
            if (icConf instanceof IC_Conf_Corpus) {
                IC_Conf_Corpus icConfCorpus = (IC_Conf_Corpus)icConf;
                cl = Class.forName(icClassName);
                co = cl.getConstructor(new Class[0]);
                o = (ICcorpus)co.newInstance(new Object[0]);
                results = o.compute(icConfCorpus, this);
            } else {
                IC_Conf_Topo icConfTopo = (IC_Conf_Topo)icConf;
                cl = Class.forName(icClassName);
                co = cl.getConstructor(new Class[0]);
                o = (ICtopo)co.newInstance(new Object[0]);
                results = o.compute(icConfTopo, this);
            }
            this.cache.metrics_results.put(icConf, results);
            this.logger.info("Checking null or infinite in the ICs computed");
            for (Map.Entry<URI, Double> e : results.entrySet()) {
                if (!Double.isNaN(e.getValue()) && !Double.isInfinite(e.getValue())) continue;
                throw new SLIB_Ex_Critic("Incoherency found in IC " + icConf.getClassName() + "\nIC of vertex " + e.getKey() + " is set to " + e.getValue());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (SecurityException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (SLIB_Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        this.logger.info("ic " + icConf.getLabel() + " computed");
        this.logger.info("---------------------------------------------------------------");
        return Collections.unmodifiableMap(this.cache.metrics_results.get((Object)icConf));
    }

    public synchronized Map<URI, Set<URI>> getReachableLeaves() {
        if (this.cache.reachableLeaves.isEmpty()) {
            Map leaves = this.descGetter.getTerminalVertices();
            for (URI c : this.classes) {
                if (leaves.containsKey(c)) continue;
                HashSet<URI> s = new HashSet<URI>();
                s.add(c);
                leaves.put(c, s);
            }
            this.cache.reachableLeaves = leaves;
        }
        return Collections.unmodifiableMap(this.cache.reachableLeaves);
    }

    public synchronized Set<URI> getReachableLeaves(URI uri) {
        return Collections.unmodifiableSet(this.getReachableLeaves().get(uri));
    }

    public Set<URI> getTaxonomicLeaves() {
        return Collections.unmodifiableSet(this.classesLeaves);
    }

    public synchronized Map<URI, Integer> getAllNbReachableLeaves() throws SLIB_Ex_Critic {
        this.logger.info("Computing Nb Reachable Leaves : start");
        if (this.cache.allNbReachableLeaves == null) {
            Map<URI, Set<URI>> allReachableLeaves = this.getReachableLeaves();
            this.cache.allNbReachableLeaves = new HashMap<URI, Integer>();
            for (URI c : this.classes) {
                if (!allReachableLeaves.containsKey(c)) {
                    throw new SLIB_Ex_Critic("Cannot found the number of leaves associated to concept " + c + " - this is abnormal and notify that their is an incoherency in the treatment, please notify this error to the development team");
                }
                this.cache.allNbReachableLeaves.put(c, allReachableLeaves.get(c).size());
            }
        }
        this.logger.info("Computing Nb Reachable Leaves : end");
        return Collections.unmodifiableMap(this.cache.allNbReachableLeaves);
    }

    public Map<URI, Integer> getAllNbAncestorsInc() throws SLIB_Ex_Critic {
        Map<URI, Set<URI>> allAncestors = this.cache.ancestorsInc;
        HashMap<URI, Integer> allNbancestors = new HashMap<URI, Integer>();
        for (URI c : this.classes) {
            allNbancestors.put(c, allAncestors.get(c).size());
        }
        return allNbancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compare(SMconf pairwiseConf, URI a, URI b) throws SLIB_Ex_Critic {
        double sim;
        block19: {
            this.throwErrorIfNotClass(a);
            this.throwErrorIfNotClass(b);
            sim = -1.7976931348623157E308;
            try {
                Sim_Pairwise pMeasure;
                if (this.cachePairwiseResults && this.cache.pairwise_results.containsKey((Object)pairwiseConf) && this.cache.pairwise_results.get((Object)pairwiseConf).containsKey(a) && this.cache.pairwise_results.get((Object)pairwiseConf).get(a).containsKey(b)) {
                    sim = this.cache.pairwise_results.get((Object)pairwiseConf).get(a).get(b);
                    break block19;
                }
                Map<SMconf, Sim_Pairwise> map = this.pairwiseMeasures;
                synchronized (map) {
                    if (this.pairwiseMeasures.containsKey((Object)pairwiseConf)) {
                        pMeasure = this.pairwiseMeasures.get((Object)pairwiseConf);
                    } else {
                        Class<?> cl = Class.forName(pairwiseConf.getClassName());
                        Constructor<?> co = cl.getConstructor(new Class[0]);
                        pMeasure = (Sim_Pairwise)co.newInstance(new Object[0]);
                        this.pairwiseMeasures.put(pairwiseConf, pMeasure);
                    }
                }
                sim = pMeasure.compare(a, b, this, pairwiseConf);
                if (Double.isNaN(sim) || Double.isInfinite(sim)) {
                    SMutils.throwArithmeticCriticalException(pairwiseConf, a, b, sim);
                }
                if (this.cachePairwiseResults) {
                    if (this.cache.pairwise_results.get((Object)pairwiseConf) == null) {
                        ConcurrentHashMap pairwise_result = new ConcurrentHashMap();
                        this.cache.pairwise_results.put(pairwiseConf, pairwise_result);
                    }
                    if (this.cache.pairwise_results.get((Object)pairwiseConf).get(a) == null) {
                        this.cache.pairwise_results.get((Object)pairwiseConf).put(a, new HashMap());
                    }
                    this.cache.pairwise_results.get((Object)pairwiseConf).get(a).put(b, sim);
                }
            }
            catch (ClassNotFoundException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (SecurityException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
            catch (SLIB_Exception e) {
                throw new SLIB_Ex_Critic((Throwable)e);
            }
        }
        return sim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compare(SMconf confGroupwise, Set<URI> setA, Set<URI> setB) throws SLIB_Ex_Critic {
        this.throwErrorIfNullOrEmpty(setA);
        this.throwErrorIfNullOrEmpty(setB);
        this.throwErrorIfNotClass(setA);
        this.throwErrorIfNotClass(setB);
        double sim = -1.7976931348623157E308;
        try {
            Sim_Groupwise_Direct gMeasure;
            Map<SMconf, Sim_Groupwise_Direct> map = this.groupwiseStandaloneMeasures;
            synchronized (map) {
                if (this.groupwiseStandaloneMeasures.containsKey((Object)confGroupwise)) {
                    gMeasure = this.groupwiseStandaloneMeasures.get((Object)confGroupwise);
                } else {
                    String groupwiseClassName = confGroupwise.getClassName();
                    Class<?> cl = Class.forName(groupwiseClassName);
                    Constructor<?> co = cl.getConstructor(new Class[0]);
                    gMeasure = (Sim_Groupwise_Direct)co.newInstance(new Object[0]);
                    this.groupwiseStandaloneMeasures.put(confGroupwise, gMeasure);
                }
            }
            sim = gMeasure.compare(setA, setB, this, confGroupwise);
        }
        catch (ClassNotFoundException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (SecurityException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        catch (SLIB_Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        return sim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double compare(SMconf confGroupwise, SMconf confPairwise, Set<URI> setA, Set<URI> setB) throws SLIB_Ex_Critic {
        this.throwErrorIfNullOrEmpty(setA);
        this.throwErrorIfNullOrEmpty(setB);
        this.throwErrorIfNotClass(setA);
        this.throwErrorIfNotClass(setB);
        double sim = -1.7976931348623157E308;
        try {
            Sim_Groupwise_Indirect gMeasure;
            Map<SMconf, Sim_Groupwise_Indirect> map = this.groupwiseAddOnMeasures;
            synchronized (map) {
                if (this.groupwiseAddOnMeasures.containsKey((Object)confGroupwise)) {
                    gMeasure = this.groupwiseAddOnMeasures.get((Object)confGroupwise);
                } else {
                    String groupwiseClassName = confGroupwise.getClassName();
                    Class<?> cl = Class.forName(groupwiseClassName);
                    Constructor<?> co = cl.getConstructor(new Class[0]);
                    gMeasure = (Sim_Groupwise_Indirect)co.newInstance(new Object[0]);
                    this.groupwiseAddOnMeasures.put(confGroupwise, gMeasure);
                }
            }
            sim = gMeasure.compare(setA, setB, this, confGroupwise, confPairwise);
        }
        catch (ClassNotFoundException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (SecurityException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (SLIB_Exception e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        return sim;
    }

    public Map<URI, Integer> getnbPathLeadingToAllVertex() throws SLIB_Ex_Critic {
        if (this.cache.nbPathLeadingToAllVertices == null) {
            this.cache.nbPathLeadingToAllVertices = this.descGetter.computeNbPathLeadingToAllVertices();
        }
        return Collections.unmodifiableMap(this.cache.nbPathLeadingToAllVertices);
    }

    public Map<URI, Integer> getNbInstancesInferredPropFromCorpus(boolean addAnInstanceToEachTerminalClass) {
        HashMap instancesOfClasses = new HashMap();
        for (URI i : this.instances) {
            Set directClassOfi = this.graph.getV(i, RDF.TYPE, Direction.OUT);
            if (directClassOfi == null) continue;
            for (URI c : directClassOfi) {
                if (instancesOfClasses.get(c) == null) {
                    instancesOfClasses.put(c, new HashSet());
                }
                ((Set)instancesOfClasses.get(c)).add(i);
            }
        }
        Set roots = new ValidatorDAG().getDAGRoots(this.graph, this.ancGetter.getWalkConstraint());
        DFS dfs = new DFS(this.graph, roots, WalkConstraintUtils.getInverse((WalkConstraint)this.ancGetter.getWalkConstraint(), (boolean)false));
        List topoOrdering = dfs.getTraversalOrder();
        HashMap<URI, Integer> rStack = new HashMap<URI, Integer>();
        for (URI c : topoOrdering) {
            if (instancesOfClasses.get(c) == null) {
                instancesOfClasses.put(c, new HashSet());
            }
            if (!addAnInstanceToEachTerminalClass || !this.graph.getE(RDFS.SUBCLASSOF, c, Direction.IN).isEmpty()) continue;
            ((Set)instancesOfClasses.get(c)).add(c);
        }
        for (URI c : topoOrdering) {
            Set instanceOfc = (Set)instancesOfClasses.get(c);
            rStack.put(c, instanceOfc.size());
            for (E e : this.graph.getE(c, this.ancGetter.getWalkConstraint())) {
                if (instanceOfc.isEmpty()) continue;
                ((Set)instancesOfClasses.get(e.getTarget())).addAll(instanceOfc);
            }
        }
        this.cache.nbOccurrencePropagatted = rStack;
        return Collections.unmodifiableMap(this.cache.nbOccurrencePropagatted);
    }

    public Map<URI, Integer> getNbOccurrenceProp() throws SLIB_Exception {
        if (this.cache.nbOccurrencePropagatted == null) {
            Map nbOccurrencesPropagated;
            RVF_TAX RVF2 = new RVF_TAX(this.graph, Direction.IN);
            HashMap<URI, Integer> nbOccurrences = new HashMap<URI, Integer>();
            for (URI o : this.classes) {
                nbOccurrences.put(o, 1);
            }
            this.cache.nbOccurrencePropagatted = nbOccurrencesPropagated = RVF2.propagateNbOccurences(nbOccurrences);
        }
        return Collections.unmodifiableMap(this.cache.nbOccurrencePropagatted);
    }

    public MatrixDouble<URI, URI> getMatrixScore(Set<URI> setA, Set<URI> setB, SMconf pairwiseConf) throws SLIB_Ex_Critic {
        this.throwErrorIfNotClass(setA);
        this.throwErrorIfNotClass(setB);
        MatrixDouble m = new MatrixDouble(setA, setB);
        for (URI a : setA) {
            for (URI b : setB) {
                m.setValue((Object)a, (Object)b, Double.valueOf(this.compare(pairwiseConf, a, b)));
            }
        }
        return m;
    }

    public boolean isCachePairwiseResults() {
        return this.cachePairwiseResults;
    }

    public void setCachePairwiseResults(boolean cachePairwiseResults) {
        this.logger.info("Pairwise results caching set to " + cachePairwiseResults);
        this.cachePairwiseResults = cachePairwiseResults;
    }

    public Map<URI, Double> getVector(Set<URI> set, SMconf groupwiseconf) {
        if (this.vectorWeights == null) {
            this.vectorWeights = VectorWeight_Chabalier_2007.compute(this);
        }
        HashMap<URI, Double> vector = new HashMap<URI, Double>();
        Set<URI> setAncestors = set;
        for (Map.Entry<URI, Double> e : this.vectorWeights.entrySet()) {
            URI v = e.getKey();
            if (setAncestors.contains(v)) {
                vector.put(v, e.getValue());
                continue;
            }
            vector.put(v, 0.0);
        }
        return vector;
    }

    public G getGraph() {
        return this.graph;
    }

    public void setICSvalues(ICconf icConf, Map<URI, Double> ics) {
        this.cache.metrics_results.put(icConf, ics);
    }

    public Set<URI> getLCAs(URI a, URI b) throws SLIB_Exception {
        return this.lcaFinder.getLCAs(a, b);
    }

    public GWS getWeightingScheme(String param) {
        return new GWS_impl(1.0);
    }

    public AncestorEngine getAncestorEngine() {
        return this.ancGetter;
    }

    public DescendantEngine getDescendantEngine() {
        return this.descGetter;
    }

    private void computeLeaves() {
        this.classesLeaves = new HashSet<URI>();
        WalkConstraint wc = this.descGetter.getWalkConstraint();
        for (URI v : this.classes) {
            if (!this.graph.getV(v, wc).isEmpty()) continue;
            this.classesLeaves.add(v);
        }
    }

    public Set<URI> getClasses() {
        return this.classes;
    }

    public Set<URI> getInstances() {
        return this.instances;
    }

    private void throwErrorIfNotClass(URI c) {
        if (!this.classes.contains(c)) {
            throw new IllegalArgumentException("The given URI " + c + " cannot be associated to a class");
        }
    }

    private void throwErrorIfNotClass(Set<URI> c) {
        if (!this.classes.containsAll(c)) {
            String ex = null;
            for (URI ce : c) {
                if (this.classes.contains(ce)) continue;
                ex = ce.toString();
                break;
            }
            throw new IllegalArgumentException("The given set of URIs " + c + " cannot be associated to a class, e.g. " + ex);
        }
    }

    private void throwErrorIfNullOrEmpty(Set<URI> set) {
        if (set == null) {
            throw new IllegalArgumentException("Error the given set equals nul...");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Error the given set is empty...");
        }
    }

    public double getShortestPath(URI a, URI b, GWS weightingScheme) throws SLIB_Ex_Critic {
        if (this.cache.shortestPath.get(a) == null || this.cache.shortestPath.get(a).get(b) == null) {
            if (this.cache.shortestPath.get(a) == null) {
                this.cache.shortestPath.put(a, new ConcurrentHashMap());
            }
            WalkConstraint wc = WalkConstraintUtils.copy((WalkConstraint)this.ancGetter.getWalkConstraint());
            wc.addWalkconstraints(this.descGetter.getWalkConstraint());
            Dijkstra dijkstra = new Dijkstra(this.graph, wc, weightingScheme);
            double sp = dijkstra.shortestPath(a, b);
            this.cache.shortestPath.get(a).put(b, sp);
        }
        return this.cache.shortestPath.get(a).get(b);
    }

    public URI getMSA(URI a, URI b, GWS weightingScheme) throws SLIB_Ex_Critic {
        Dijkstra dijkstra = new Dijkstra(this.graph, this.ancGetter.getWalkConstraint(), weightingScheme);
        URI msa_pk = SimDagEdgeUtils.getMSA_pekar_staab(this.getRoot(), this.getAllShortestPath(a, weightingScheme), this.getAllShortestPath(b, weightingScheme), this.getAncestorsInc(a), this.getAncestorsInc(b), dijkstra);
        return msa_pk;
    }

    public synchronized Map<URI, Double> getAllShortestPath(URI a, GWS weightingScheme) throws SLIB_Ex_Critic {
        if (this.cache.shortestPath.get(a) == null) {
            WalkConstraint wc = WalkConstraintUtils.copy((WalkConstraint)this.ancGetter.getWalkConstraint());
            wc.addWalkconstraints(this.descGetter.getWalkConstraint());
            Dijkstra dijkstra = new Dijkstra(this.graph, wc, weightingScheme);
            ConcurrentHashMap minDists_cA = dijkstra.shortestPath(a);
            this.cache.shortestPath.put(a, minDists_cA);
        }
        return this.cache.shortestPath.get(a);
    }

    public double getP_MICA(ICconf conf, URI a, URI b) throws SLIB_Exception {
        double prob_mica = IcUtils.searchMin_pOc_MICA(this.getAncestorsInc(a), this.getAncestorsInc(b), this.getIC_results(conf));
        return prob_mica;
    }

    public Set<URI> getHypoAncEx(URI a, URI b) {
        Set<URI> anc_a = this.getAncestorsInc(a);
        Set<URI> anc_b = this.getAncestorsInc(b);
        Set unionAncestors = SetUtils.union(anc_a, anc_b);
        Set interAncestors = SetUtils.union(anc_a, anc_b);
        Set ancsEx = unionAncestors;
        unionAncestors.removeAll(interAncestors);
        Set<Object> hypoAncsEx = new HashSet<URI>();
        for (URI v : ancsEx) {
            Set descCurAnc = this.descGetter.getRV(v);
            hypoAncsEx = SetUtils.union(hypoAncsEx, (Collection)descCurAnc);
        }
        return hypoAncsEx;
    }
}

