/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.framework.dag;

import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.framework.dag.Sim_Framework_DAG_Set_abstract;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.impl.SetUtils;

public class Sim_Framework_DAG_Set_Batet_2010
extends Sim_Framework_DAG_Set_abstract {
    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) {
        int nbV = c.getClasses().size();
        Set<URI> ancA = c.getAncestorsInc(a);
        Set<URI> ancB = c.getAncestorsInc(b);
        return this.compare(nbV, ancA, ancB);
    }

    @Override
    public double compare(Set<URI> setA, Set<URI> setB, SM_Engine c, SMconf conf) {
        int nbV = c.getClasses().size();
        Set<URI> ancA = c.getAncestorsInc(setA);
        Set<URI> ancB = c.getAncestorsInc(setB);
        return this.compare(nbV, ancA, ancB);
    }

    @Override
    public double compare(Set<URI> ancA, Set<URI> ancB, SMconf conf) {
        double batet;
        Set interSecAncestors = SetUtils.intersection(ancA, ancB);
        Set unionAncestors = SetUtils.union(ancA, ancB);
        double num = unionAncestors.size() - interSecAncestors.size();
        if (num == 0.0) {
            batet = 1.0;
        } else {
            batet = -Math.log(num / (double)unionAncestors.size());
            batet /= Math.log(unionAncestors.size());
        }
        return batet;
    }

    public double compare(int nbVertices, Set<URI> a, Set<URI> b) {
        double batet;
        Set interSecAncestors = SetUtils.intersection(a, b);
        Set unionAncestors = SetUtils.union(a, b);
        double num = unionAncestors.size() - interSecAncestors.size();
        if (num == 0.0) {
            batet = 1.0;
        } else {
            batet = -Math.log(num / (double)unionAncestors.size());
            batet /= Math.log(nbVertices);
        }
        return batet;
    }

    @Override
    public Boolean isSymmetric() {
        return true;
    }
}

