/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.edge_based;

import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.model.graph.weight.GWS;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.Sim_DAG_edge_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_pairwise_DAG_edge_Leacock_Chodorow_1998
extends Sim_DAG_edge_abstract {
    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        GWS weightingScheme = c.getWeightingScheme(conf.getParamAsString("WEIGHTING_SCHEME"));
        Set<URI> ancestors_A = c.getAncestorsInc(a);
        Set<URI> ancestors_B = c.getAncestorsInc(b);
        Map<URI, Double> distMin_a = c.getAllShortestPath(a, weightingScheme);
        Map<URI, Double> distMin_b = c.getAllShortestPath(b, weightingScheme);
        Set interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B);
        Map<URI, Integer> maxDepths = c.getMaxDepths();
        double sp_a_mrca = -1.0;
        double sp_b_mrca = -1.0;
        if (interSecAncestors.isEmpty()) {
            throw new SLIB_Ex_Critic("Error using Leacock & Chodorow measure. The compared concepts (" + a + "," + b + ") do not have a common ancestor... This is required to compute their similarity using this measure. The graph have to be connex, you can root the graph to obtain such a graph.");
        }
        URI msa = SimDagEdgeUtils.searchMSA(interSecAncestors, maxDepths);
        sp_a_mrca = distMin_a.get(msa);
        sp_b_mrca = distMin_b.get(msa);
        if (sp_a_mrca == -1.0 || sp_b_mrca == -1.0) {
            throw new SLIB_Ex_Critic("Error using Leacock & Chodorow measure processing concepts (" + a + "," + b + ")... Impossible to compute the length of shortest path linking the concepts and their most common ancestors.");
        }
        double sp = sp_a_mrca + sp_b_mrca;
        double maxDepth = c.getMaxDepth();
        return this.sim(sp, maxDepth);
    }

    public double sim(Double shortestPath, double depth_max) {
        double lc = -Math.log((shortestPath + 1.0) / (2.0 * depth_max));
        return lc;
    }

    @Override
    public Boolean isSymmetric() {
        return true;
    }
}

