/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based;

import java.text.DecimalFormat;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_pairwise_DAG_node_IC_Prop_Tversky_Contrast_Model
extends Sim_DAG_node_abstract {
    public static final String gamma_param_name = "gamma";
    public static final String alpha_param_name = "alpha";
    public static final String beta_param_name = "beta";
    protected double gamma = 1.0;
    protected double alpha = 1.0;
    protected double beta = 1.0;

    public Sim_pairwise_DAG_node_IC_Prop_Tversky_Contrast_Model() {
    }

    public Sim_pairwise_DAG_node_IC_Prop_Tversky_Contrast_Model(double gamma, double alpha, double beta) {
        this.gamma = gamma;
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        if (conf != null && conf.containsParam(gamma_param_name)) {
            this.gamma = conf.getParamAsDouble(gamma_param_name);
        }
        if (conf != null && conf.containsParam(alpha_param_name)) {
            this.alpha = conf.getParamAsDouble(alpha_param_name);
        }
        if (conf != null && conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        if (conf == null || conf.getICconf() == null) {
            throw new IllegalArgumentException("Measure " + this.getClass().getSimpleName() + " requires a configuration to be specified an IC to be specified");
        }
        ICconf icConf = conf.getICconf();
        double ic_a = 0.0;
        double ic_b = 0.0;
        double ic_common = 0.0;
        for (URI u : c.getAncestorsInc(a)) {
            ic_a += c.getIC(icConf, u);
        }
        for (URI u : c.getAncestorsInc(b)) {
            ic_b += c.getIC(icConf, u);
        }
        for (URI u : SetUtils.intersection(c.getAncestorsInc(a), c.getAncestorsInc(b))) {
            ic_common += c.getIC(icConf, u);
        }
        try {
            return Sim_pairwise_DAG_node_IC_Prop_Tversky_Contrast_Model.sim(ic_a, ic_b, ic_common, this.gamma, this.alpha, this.beta);
        }
        catch (SLIB_Ex_Critic ex) {
            throw new SLIB_Ex_Critic(ex.getMessage() + "\n" + "A = " + a + ", ancestors " + c.getAncestorsInc(a).size() + "\n" + "B = " + b + ", ancestors " + c.getAncestorsInc(b).size() + "\n" + "MICA , ancestors " + SetUtils.intersection(c.getAncestorsInc(a), c.getAncestorsInc(b)).size() + "\n");
        }
    }

    public static double sim(double ic_a, double ic_b, double ic_mica, double gamma, double alpha, double beta) throws SLIB_Ex_Critic {
        if (ic_mica > ic_a || ic_mica > ic_b) {
            DecimalFormat df = new DecimalFormat("#0.######");
            ic_mica = Double.parseDouble(df.format(ic_mica));
            ic_a = Double.parseDouble(df.format(ic_a));
            ic_b = Double.parseDouble(df.format(ic_b));
            if (ic_mica > ic_a || ic_mica > ic_b) {
                throw new SLIB_Ex_Critic("Wrong parameters used with Tversky measure. IC MICA must be inferior to IC(a) and IC(b) \nIC A =  " + ic_a + "\n" + "IC B =  " + ic_b + "\n" + "IC MICA =  " + ic_mica + "\n");
            }
        }
        double j = 0.0;
        if (ic_mica != 0.0) {
            j = gamma * ic_mica - alpha * (ic_a - ic_mica) - beta * (ic_b - ic_mica);
        }
        return j;
    }

    @Override
    public Boolean isSymmetric() {
        return this.alpha == this.beta;
    }
}

