/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.node_based.experimental;

import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_DAG_node_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.node_based.Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model;
import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class Sim_pairwise_DAG_node_Schlicker_Tversky_SimRel
extends Sim_DAG_node_abstract {
    public static final String alpha_param_name = "alpha";
    public static final String beta_param_name = "beta";
    private double alpha = 0.5;
    private double beta = 0.5;

    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        ICconf confic;
        double ic_a = c.getIC(conf.getICconf(), a);
        double ic_b = c.getIC(conf.getICconf(), b);
        double ic_MICA = c.getIC_MICA(conf.getICconf(), a, b);
        if (conf.containsParam(alpha_param_name)) {
            this.alpha = conf.getParamAsDouble(alpha_param_name);
        }
        if (conf.containsParam(beta_param_name)) {
            this.beta = conf.getParamAsDouble(beta_param_name);
        }
        if ((confic = (ICconf)((Object)conf.getParam("ic_prob"))) == null) {
            throw new SLIB_Ex_Critic("Measure " + this.getClass().getSimpleName() + " requires a parameter: " + "ic_prob");
        }
        double p_MICA = c.getP_MICA(confic, a, b);
        if (p_MICA < 0.0 || p_MICA > 1.0) {
            throw new SLIB_Ex_Critic("Probability measure is expected... Given IC " + confic.getId() + " is not suited as it apparently doesn't provide values restricted in [0,1] ");
        }
        return this.sim(ic_a, ic_b, ic_MICA, p_MICA, this.alpha, this.beta);
    }

    public double sim(double ic_a, double ic_b, double ic_mica, double p_mica, double alpha, double beta) throws SLIB_Ex_Critic {
        double sim = Sim_pairwise_DAG_node_IC_Tversky_Ratio_Model.sim(ic_a, ic_b, ic_mica, alpha, beta);
        return sim * (1.0 - p_mica);
    }
}

