/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.ic.utils.ProbOccurence;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_resnik_1995
extends LogBasedMetric
implements ICtopo {
    public Map<URI, Double> compute(Map<URI, Integer> nbPLeadingToAllVertex) throws SLIB_Ex_Critic {
        Map<URI, Double> rtemp = ProbOccurence.compute(nbPLeadingToAllVertex, 0);
        double max = Collections.max(nbPLeadingToAllVertex.values()).intValue();
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        for (URI v : nbPLeadingToAllVertex.keySet()) {
            double curIc = -MathSML.log(rtemp.get(v), this.getLogBase());
            double curIc_norm = curIc / MathSML.log(max, this.getLogBase());
            results.put(v, curIc_norm);
        }
        return results;
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine manager) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        return this.compute(manager.getnbPathLeadingToAllVertex());
    }
}

