/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_sanchez_2011_b_adapted
extends LogBasedMetric
implements ICtopo {
    public Map<URI, Double> compute(Map<URI, Integer> allNbOfReachableLeaves) throws SLIB_Ex_Critic {
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        int max_leaves = Collections.max(allNbOfReachableLeaves.values());
        double y = (double)max_leaves + 1.0;
        for (URI v : allNbOfReachableLeaves.keySet()) {
            double nbLeaves = allNbOfReachableLeaves.get(v).intValue();
            double x = nbLeaves + 1.0;
            double cur_ic = -MathSML.log(x / y, this.getLogBase());
            double cur_ic_norm = cur_ic / MathSML.log(y, this.getLogBase());
            results.put(v, cur_ic_norm);
        }
        return results;
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine manager) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        return this.compute(manager.getAllNbReachableLeaves());
    }
}

