/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.utils;

import slib.sml.sm.core.metrics.ic.utils.ICconf;
import slib.sml.sm.core.utils.SMConstants;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.i.Conf;

public class SMconf
extends Conf {
    private String id;
    private String flag;
    private String className;
    private String label;
    private ICconf icConf;

    public SMconf(String flag) throws SLIB_Ex_Critic {
        this(flag, flag);
    }

    public SMconf(String id, String flag) throws SLIB_Ex_Critic {
        this(id, flag, id);
    }

    public SMconf(String id, String flag, String label) throws SLIB_Ex_Critic {
        this(id, flag, label, null);
    }

    public SMconf(String flag, ICconf icConf) throws SLIB_Ex_Critic {
        this(flag, flag, flag, icConf);
    }

    public SMconf(String id, String flag, ICconf icConf) throws SLIB_Ex_Critic {
        this(id, flag, id, icConf);
    }

    public SMconf(String id, String flag, String label, ICconf icConf) throws SLIB_Ex_Critic {
        this.id = id;
        this.flag = flag;
        this.label = label;
        this.icConf = icConf;
        this.init();
    }

    private void init() throws SLIB_Ex_Critic {
        this.className = SMConstants.semanticMeasureClassName(this.flag);
        if (this.className == null) {
            throw new SLIB_Ex_Critic("Cannot resolve Semantic measure associated to flag: '" + this.flag + "'");
        }
    }

    public ICconf getICconf() {
        return this.icConf;
    }

    public void setICconf(ICconf ic) {
        this.icConf = ic;
    }

    public String toString() {
        String out = "id : " + this.id + "\n";
        out = out + "flag : " + this.flag + "\n";
        out = out + "className : " + this.className + "\n";
        out = out + "label : " + this.label + "\n";
        out = out + "icConf : \n" + (Object)((Object)this.icConf) + "\n";
        out = out + "Extra parameters : " + super.toString();
        return out;
    }

    public SMconf addParam(String p, Object v) {
        super.addParam(p, v);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getFlag() {
        return this.flag;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ICconf getIcConf() {
        return this.icConf;
    }
}

