/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.smutils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import slib.utils.ex.SLIB_Ex_Critic;
import slib.utils.ex.SLIB_Exception;

public class SQLiteUtils {
    Logger logger = LoggerFactory.getLogger(SQLiteUtils.class);
    public static int BATCH_LIMIT = 25000;
    public static int BATCH_LIMIT_MATRIX_LINE = 1000;
    private String e_A_flag = "entity_A";
    private String e_B_flag = "entity_B";

    private String[] getHeader(String filepath) throws SLIB_Ex_Critic {
        String[] header = null;
        try {
            String line;
            FileInputStream fstream = new FileInputStream(filepath);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("!") || line.isEmpty()) continue;
                header = line.split("\t");
                break;
            }
            in.close();
        }
        catch (IOException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        return header;
    }

    private String implodeArray(String[] array) {
        String output = "";
        StringBuilder sb = new StringBuilder();
        sb.append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append("\t");
            sb.append(array[i]);
        }
        output = sb.toString();
        return output;
    }

    public void createTableDB(String filepath, String db, String tableName) throws SLIB_Ex_Critic {
        this.logger.info("Create SQLlite DB from " + filepath);
        this.logger.info("Batch limit : " + BATCH_LIMIT);
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            Statement stat = conn.createStatement();
            stat.executeUpdate("drop table if exists " + tableName + ";");
            String[] header = this.getHeader(filepath);
            if (header == null) {
                throw new SLIB_Ex_Critic("Cannot locate header of file " + filepath);
            }
            if (header.length < 2) {
                throw new SLIB_Ex_Critic("Corrupted file " + filepath + ", header must contains at least two fields dtected header :" + this.implodeArray(header));
            }
            this.logger.info("Populating SQLlite DB ... be patient");
            String methodNames = "";
            String methodNames_q = "";
            for (int i = 2; i < header.length; ++i) {
                methodNames = methodNames + ", \"" + header[i] + "\"";
                methodNames_q = methodNames_q + ",?";
            }
            String header_db = "\"" + this.e_A_flag + "\", \"" + this.e_B_flag + "\"" + methodNames;
            this.logger.info("Header: " + header_db);
            String query = "create table " + tableName + " (" + header_db + ")";
            this.logger.debug("query: " + query);
            stat.executeUpdate(query);
            PreparedStatement prep = conn.prepareStatement("insert into " + tableName + " values (?, ?" + methodNames_q + ");");
            conn.setAutoCommit(false);
            try {
                String line;
                FileInputStream fstream = new FileInputStream(filepath);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                long countLine = 0L;
                int batchCount = 0;
                long processed = 0L;
                boolean headerb = false;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    ++countLine;
                    if (line.startsWith("!") || line.isEmpty()) continue;
                    String[] data = line.split("\t");
                    if (!headerb) {
                        headerb = true;
                        continue;
                    }
                    if (data.length != header.length) {
                        throw new SLIB_Ex_Critic("Corrupted file " + filepath + ", result line " + countLine + " contains abnormal number of values considering header");
                    }
                    for (int j = 0; j < data.length; ++j) {
                        if (j < 2) {
                            prep.setString(j + 1, data[j]);
                            continue;
                        }
                        prep.setDouble(j + 1, Double.parseDouble(data[j]));
                    }
                    prep.addBatch();
                    if (++batchCount == BATCH_LIMIT) {
                        prep.executeBatch();
                        batchCount = 0;
                    }
                    if (++processed % (long)BATCH_LIMIT != 0L) continue;
                    this.logger.info("processed " + processed);
                }
                in.close();
            }
            catch (IOException e) {
                throw new SLIB_Ex_Critic(e.getMessage());
            }
            prep.executeBatch();
            conn.commit();
            conn.close();
            this.logger.info("Table " + tableName + " created in database " + db);
        }
        catch (SQLException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SLIB_Ex_Critic((Throwable)e);
        }
    }

    public void mergeTables(String db_tAB, String table_A, String table_B, String db_tmerge, String table_merge) throws SLIB_Exception {
        this.mergeTables(db_tAB, table_A, db_tAB, table_B, db_tmerge, table_merge);
    }

    public void mergeTables(String db_tA, String table_A, String db_tB, String table_B, String db_tmerge, String table_merge) throws SLIB_Ex_Critic {
        this.logger.info("Loading SQLlite DB : " + table_A + " from " + db_tA + "  " + table_B + " from " + db_tB);
        this.logger.info("Batch limit : " + BATCH_LIMIT);
        try {
            String columnName;
            Class.forName("org.sqlite.JDBC");
            Connection conn_A = DriverManager.getConnection("jdbc:sqlite:" + db_tA);
            Connection conn_B = db_tA.equals(db_tB) ? conn_A : DriverManager.getConnection("jdbc:sqlite:" + db_tB);
            Connection conn_M = db_tA.equals(db_tmerge) ? conn_A : (db_tB.equals(db_tmerge) ? conn_B : DriverManager.getConnection("jdbc:sqlite:" + db_tmerge));
            Statement stat_A = conn_A.createStatement();
            Statement stat_B = conn_B.createStatement();
            Statement stat_M = conn_M.createStatement();
            stat_M.executeUpdate("drop table if exists " + table_merge + ";");
            this.logger.info("Merging SQLlite DB  to " + db_tmerge + " table " + table_merge + "... be patient");
            DatabaseMetaData meta_A = conn_A.getMetaData();
            DatabaseMetaData meta_B = conn_B.getMetaData();
            if (!this.tablesExists(meta_A, table_A)) {
                throw new SLIB_Ex_Critic("Cannot find table " + table_A + " in database " + db_tA);
            }
            if (!this.tablesExists(meta_B, table_B)) {
                throw new SLIB_Ex_Critic("Cannot find table " + table_B + " in database " + db_tB);
            }
            ArrayList<String> colNames_tA = new ArrayList<String>();
            ArrayList<String> colNames_tB = new ArrayList<String>();
            ResultSet rsColumns = meta_A.getColumns(null, null, table_A, null);
            while (rsColumns.next()) {
                columnName = rsColumns.getString("COLUMN_NAME");
                colNames_tA.add(columnName);
            }
            rsColumns.close();
            rsColumns = meta_B.getColumns(null, null, table_B, null);
            while (rsColumns.next()) {
                columnName = rsColumns.getString("COLUMN_NAME");
                colNames_tB.add(columnName);
            }
            rsColumns.close();
            ArrayList<String> columnsNames_tableToRemove = new ArrayList<String>();
            columnsNames_tableToRemove.add(this.e_A_flag);
            columnsNames_tableToRemove.add(this.e_B_flag);
            for (int i = 2; i < colNames_tB.size(); ++i) {
                if (!colNames_tA.contains(colNames_tB.get(i))) continue;
                this.logger.info("skipping column results " + (String)colNames_tB.get(i) + " specified in table " + table_B);
                columnsNames_tableToRemove.add((String)colNames_tB.get(i));
            }
            int[] colNames_tB_id = new int[colNames_tB.size() - columnsNames_tableToRemove.size()];
            int id = 0;
            for (int i = 0; i < colNames_tB.size(); ++i) {
                if (columnsNames_tableToRemove.contains(colNames_tB.get(i))) continue;
                colNames_tB_id[id] = i + 1;
                ++id;
            }
            colNames_tB.removeAll(columnsNames_tableToRemove);
            ArrayList headerMerge = (ArrayList)colNames_tA.clone();
            headerMerge.addAll(colNames_tB);
            this.logger.info("Final header : " + headerMerge);
            if (colNames_tB.size() == 0) {
                throw new SLIB_Exception("Empty table " + table_A + ", no values to merge");
            }
            if (colNames_tB.size() == 0) {
                throw new SLIB_Exception("Empty table " + table_B + ", no values to merge");
            }
            String header_m = "\"" + this.e_A_flag + "\",\"" + this.e_B_flag + "\"";
            String header_q = "?,?";
            for (int i = 2; i < headerMerge.size(); ++i) {
                header_m = header_m + ", \"" + (String)headerMerge.get(i) + "\"";
                header_q = header_q + ", ?";
            }
            int batchCount = 0;
            int skipped = 0;
            int processed = 0;
            ResultSet rs_tA = stat_A.executeQuery("select * from " + table_A + ";");
            ResultSet rs_tB = stat_B.executeQuery("select * from " + table_B + ";");
            ResultSet rez = null;
            stat_M.executeUpdate("create table " + table_merge + " (" + header_m + ");");
            PreparedStatement prep = conn_M.prepareStatement("insert into " + table_merge + " values (" + header_q + ");");
            conn_M.setAutoCommit(false);
            processed = 0;
            while (rs_tA.next()) {
                String e_B;
                String e_A = rs_tA.getString(this.e_A_flag);
                rez = this.getResultSet(rs_tB, stat_B, table_B, e_A, e_B = rs_tA.getString(this.e_B_flag));
                if (rez != null) {
                    int i;
                    ++processed;
                    prep.setString(1, e_A);
                    prep.setString(2, e_B);
                    int c = 3;
                    for (i = 2; i < colNames_tA.size(); ++i) {
                        prep.setDouble(c, rs_tA.getDouble(i + 1));
                        ++c;
                    }
                    for (i = 0; i < colNames_tB_id.length; ++i) {
                        prep.setDouble(i + c, rez.getDouble(colNames_tB_id[i]));
                    }
                    prep.addBatch();
                    if (++batchCount == BATCH_LIMIT) {
                        prep.executeBatch();
                        batchCount = 0;
                    }
                    if (processed % BATCH_LIMIT != 0) continue;
                    this.logger.info("processed " + processed);
                    continue;
                }
                ++skipped;
                this.logger.info("skipped = " + e_A + "   " + e_B);
            }
            prep.executeBatch();
            prep.close();
            if (rez != null) {
                rez.close();
            }
            rs_tA.close();
            rs_tB.close();
            stat_A.close();
            stat_B.close();
            stat_M.close();
            conn_M.commit();
            conn_A.close();
            if (!conn_B.isClosed()) {
                conn_B.close();
            }
            if (!conn_M.isClosed()) {
                conn_M.close();
            }
            this.logger.info("Merging performed.");
            this.logger.info("merged  : " + processed);
            this.logger.info("skipped : " + skipped);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    private boolean tablesExists(DatabaseMetaData dbMetadata, String table) throws SLIB_Exception {
        try {
            ResultSet res = dbMetadata.getTables(null, null, null, new String[]{"TABLE"});
            while (res.next()) {
                if (!table.equalsIgnoreCase(res.getString("TABLE_NAME"))) continue;
                res.close();
                return true;
            }
        }
        catch (SQLException e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
        return false;
    }

    private ResultSet getResultSet(ResultSet rs, Statement stat, String table, String e_A, String e_B) throws SQLException {
        String firstTested_eA = null;
        String firstTested_eB = null;
        ResultSet rez = null;
        while (rs.next()) {
            String table_2_e1_tmp = rs.getString(this.e_A_flag);
            String table_2_e2_tmp = rs.getString(this.e_B_flag);
            if (firstTested_eA == null) {
                firstTested_eA = table_2_e1_tmp;
                firstTested_eB = table_2_e2_tmp;
            }
            if (!e_A.equals(table_2_e1_tmp) || !e_B.equals(table_2_e2_tmp)) continue;
            rez = rs;
            break;
        }
        if (rez == null) {
            rs.close();
            rs = stat.executeQuery("select * from " + table + ";");
            while (rs.next()) {
                String e__b_A = rs.getString(this.e_A_flag);
                String e__b_B = rs.getString(this.e_B_flag);
                if (firstTested_eA == null) {
                    firstTested_eA = e__b_A;
                    firstTested_eB = e__b_B;
                }
                if (e_A.equals(e__b_A) && e_B.equals(e__b_B)) {
                    rez = rs;
                    break;
                }
                if (!firstTested_eA.equals(e__b_A) || !firstTested_eB.equals(e__b_B)) continue;
                break;
            }
        }
        return rez;
    }

    public void flushTableInFile(String sqlLiteDB, String table, String outfile) throws SLIB_Ex_Critic {
        this.logger.info("flushing SQLlite table " + table + " of database " + sqlLiteDB + " in " + outfile);
        this.logger.info("Batch limit (matrix line) : " + BATCH_LIMIT_MATRIX_LINE);
        this.logger.info("Please wait...");
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + sqlLiteDB);
            Statement stat = conn.createStatement();
            DatabaseMetaData meta = conn.getMetaData();
            ArrayList<String> columnsNames = new ArrayList<String>();
            int e_A_id = -1;
            int e_B_id = -1;
            ResultSet rsColumns = meta.getColumns(null, null, table, null);
            int c = 0;
            while (rsColumns.next()) {
                String columnName = rsColumns.getString("COLUMN_NAME");
                columnsNames.add(columnName);
                if (columnName.equals(this.e_A_flag)) {
                    e_A_id = c;
                } else if (columnName.equals(this.e_B_flag)) {
                    e_B_id = c;
                }
                ++c;
            }
            FileWriter fstream = new FileWriter(outfile);
            BufferedWriter outbuff = new BufferedWriter(fstream);
            StringBuilder tmp_s = new StringBuilder();
            for (int i = 0; i < columnsNames.size(); ++i) {
                if (i != 0) {
                    tmp_s.append("\t");
                }
                tmp_s.append((String)columnsNames.get(i));
            }
            outbuff.write(tmp_s.toString());
            this.logger.info("Column number : " + columnsNames.size());
            ResultSet rs = stat.executeQuery("select * from " + table + ";");
            long line = 0L;
            long lc = 0L;
            tmp_s = new StringBuilder();
            while (rs.next()) {
                ++line;
                ++lc;
                tmp_s.append("\n");
                for (int i = 0; i < columnsNames.size(); ++i) {
                    if (i != 0) {
                        tmp_s.append("\t");
                    }
                    if (i == e_A_id || i == e_B_id) {
                        tmp_s.append(rs.getString(i + 1));
                        continue;
                    }
                    tmp_s.append(rs.getDouble(i + 1));
                }
                if (lc == (long)BATCH_LIMIT_MATRIX_LINE) {
                    lc = 0L;
                    outbuff.write(tmp_s + "\n");
                    tmp_s = new StringBuilder();
                }
                if (line % (long)BATCH_LIMIT_MATRIX_LINE != 0L) continue;
                this.logger.info("processed " + line);
            }
            if (lc != 0L) {
                outbuff.write(tmp_s + "\n");
            }
            outbuff.close();
            rs.close();
            conn.close();
            this.logger.info(line + " lines flushed");
            this.logger.info("db flushed, consult " + outfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void copyTable(String db, String table, String newDB, String tableNew) throws SLIB_Ex_Critic {
        this.logger.info("Copy SQLlite DB : " + table + " from " + db + " to " + newDB + " table " + tableNew);
        this.logger.info("Batch limit : " + BATCH_LIMIT);
        boolean newDBexists = new File(newDB).exists();
        if (!newDBexists) {
            this.logger.info("Creating new database.");
        }
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            Connection connNewDB = db.equals(newDB) ? conn : DriverManager.getConnection("jdbc:sqlite:" + newDB);
            DatabaseMetaData meta = conn.getMetaData();
            DatabaseMetaData metaNew = connNewDB.getMetaData();
            if (!this.tablesExists(meta, table)) {
                throw new SLIB_Ex_Critic("Cannot locate table " + table + " in database " + db);
            }
            if (this.tablesExists(metaNew, tableNew)) {
                this.logger.info("dropt table " + tableNew + " (already exists in database " + newDB + ")");
            }
            Statement stat = conn.createStatement();
            Statement statNew = connNewDB.createStatement();
            statNew.executeUpdate("drop table if exists " + tableNew + ";");
            String colString = "";
            String colStringQ = "";
            ResultSet rsColumns = meta.getColumns(null, null, table, null);
            int colCount = 0;
            while (rsColumns.next()) {
                String columnName = rsColumns.getString("COLUMN_NAME");
                if (colCount != 0) {
                    colString = colString + ",";
                    colStringQ = colStringQ + ",";
                }
                colString = colString + "\"" + columnName + "\"";
                colStringQ = colStringQ + "?";
                ++colCount;
            }
            rsColumns.close();
            String query = "create table " + tableNew + " (" + colString + ")";
            this.logger.debug(query);
            statNew.executeUpdate(query);
            ResultSet rs = stat.executeQuery("select * from " + table + ";");
            PreparedStatement prep = connNewDB.prepareStatement("insert into " + tableNew + " values (" + colStringQ + ");");
            connNewDB.setAutoCommit(false);
            long processed = 0L;
            int batchCount = 0;
            while (rs.next()) {
                ++processed;
                String e_A = rs.getString(this.e_A_flag);
                String e_B = rs.getString(this.e_B_flag);
                prep.setString(1, e_A);
                prep.setString(2, e_B);
                for (int i = 2; i < colCount; ++i) {
                    prep.setDouble(i + 1, rs.getDouble(i + 1));
                }
                prep.addBatch();
                if (++batchCount == BATCH_LIMIT) {
                    prep.executeBatch();
                    batchCount = 0;
                }
                if (processed % (long)BATCH_LIMIT != 0L) continue;
                this.logger.info("processed " + processed);
            }
            prep.executeBatch();
            prep.close();
            statNew.close();
            connNewDB.commit();
            connNewDB.close();
            rs.close();
            stat.close();
            conn.close();
            this.logger.info("Copy performed");
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void dropColumns(String db, String table, Set<String> columnsToDrop) throws SLIB_Ex_Critic {
        this.logger.info("Drop Columns " + Arrays.toString(columnsToDrop.toArray()) + " from " + table + " of database " + db);
        this.logger.info("Batch limit : " + BATCH_LIMIT);
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            DatabaseMetaData meta = conn.getMetaData();
            if (!this.tablesExists(meta, table)) {
                throw new SLIB_Ex_Critic("Cannot locate table " + table + " in database " + db);
            }
            Statement stat = conn.createStatement();
            Statement statDrop = conn.createStatement();
            String colString = "";
            String colStringQ = "";
            ResultSet rsColumns = meta.getColumns(null, null, table, null);
            int colCount = 1;
            ArrayList<Integer> columnIds = new ArrayList<Integer>();
            while (rsColumns.next()) {
                String columnName = rsColumns.getString("COLUMN_NAME");
                if (!columnsToDrop.contains(columnName)) {
                    if (columnIds.size() != 0) {
                        colString = colString + ",";
                        colStringQ = colStringQ + ",";
                    }
                    colString = colString + "\"" + columnName + "\"";
                    colStringQ = colStringQ + "?";
                    columnIds.add(colCount);
                }
                ++colCount;
            }
            rsColumns.close();
            Random generator = new Random();
            String tmp_table = "tmp_table" + generator.nextInt(100000);
            while (this.tablesExists(meta, tmp_table)) {
                tmp_table = "tmp_table_" + generator.nextInt(100000);
            }
            String query = "create table " + tmp_table + " (" + colString + ")";
            this.logger.debug(query);
            statDrop.executeUpdate(query);
            ResultSet rs = stat.executeQuery("select " + colString + " from " + table + ";");
            PreparedStatement prep = conn.prepareStatement("insert into " + tmp_table + " values (" + colStringQ + ");");
            conn.setAutoCommit(false);
            int id = 0;
            long batchCount = 0L;
            long processed = 0L;
            while (rs.next()) {
                for (int i = 0; i < columnIds.size(); ++i) {
                    id = (Integer)columnIds.get(i);
                    if (id < 3) {
                        prep.setString(i + 1, rs.getString(i + 1));
                        continue;
                    }
                    prep.setDouble(i + 1, rs.getDouble(i + 1));
                }
                prep.addBatch();
                ++processed;
                if (++batchCount == (long)BATCH_LIMIT) {
                    prep.executeBatch();
                    batchCount = 0L;
                }
                if (processed % (long)BATCH_LIMIT != 0L) continue;
                this.logger.info("processed " + processed);
            }
            prep.executeBatch();
            prep.close();
            conn.setAutoCommit(true);
            statDrop.close();
            rs.close();
            stat.executeUpdate("drop table if exists " + table + ";");
            stat.executeUpdate("ALTER TABLE " + tmp_table + " RENAME TO " + table + ";");
            stat.close();
            conn.close();
            this.logger.info("Drop column performed");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void dropTable(String db, String table) throws SLIB_Ex_Critic {
        this.logger.info("Drop table : " + table + " from " + db);
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            Statement stat = conn.createStatement();
            stat.executeUpdate("drop table if exists " + table + ";");
            stat.close();
            conn.close();
            this.logger.info("Table dropped");
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void getInfo(String db) throws SLIB_Ex_Critic {
        this.getInfo(db, null);
    }

    public void getInfo(String db, String table) throws SLIB_Ex_Critic {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            Statement stat = conn.createStatement();
            DatabaseMetaData meta = conn.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet resultSet = meta.getTables(null, null, "%", types);
            String dbInfo = "Database " + db + " ";
            String tableInfo = "";
            int tableCount = 0;
            while (resultSet.next()) {
                ++tableCount;
                String tableName = resultSet.getString(3);
                if (table != null && (table == null || !table.equalsIgnoreCase(tableName))) continue;
                String columInfo = "";
                int columnCount = 0;
                ResultSet rs = stat.executeQuery("select COUNT(*) from " + tableName + ";");
                long rowNB = rs.getLong(1);
                ResultSet rsColumns = meta.getColumns(null, null, tableName, null);
                while (rsColumns.next()) {
                    String columnName = rsColumns.getString("COLUMN_NAME");
                    columInfo = columInfo + "\t" + columnName + "\n";
                    ++columnCount;
                }
                rsColumns.close();
                tableInfo = tableInfo + tableName + " (" + columnCount + " columns, " + rowNB + " tuples)\n";
                tableInfo = tableInfo + columInfo;
            }
            resultSet.close();
            stat.close();
            conn.close();
            dbInfo = dbInfo + "(" + tableCount + " tables) \n";
            dbInfo = dbInfo + tableInfo;
            System.out.println(dbInfo);
        }
        catch (Exception e) {
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public void renameTable(String db, String table, String newTableName) throws SLIB_Ex_Critic {
        this.logger.info("Rename table : " + table + " from " + db + " to " + newTableName);
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + db);
            Statement stat = conn.createStatement();
            stat.executeUpdate("ALTER TABLE " + table + " RENAME TO " + newTableName + ";");
            stat.close();
            conn.close();
            this.logger.info("Table renamed");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SLIB_Ex_Critic(e.getMessage());
        }
    }

    public int getBATCH_LIMIT() {
        return BATCH_LIMIT;
    }

    public void setBATCH_LIMIT(int BATCH_LIMIT) {
        SQLiteUtils.BATCH_LIMIT = BATCH_LIMIT;
    }

    public int getBATCH_LIMIT_MATRIX_LINE() {
        return BATCH_LIMIT_MATRIX_LINE;
    }

    public void setBATCH_LIMIT_MATRIX_LINE(int bATCH_LIMIT_MATRIX_LINE) {
        BATCH_LIMIT_MATRIX_LINE = bATCH_LIMIT_MATRIX_LINE;
    }
}

