/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class IncrementalProcessingStatistics {
    long changeInitContextProcessingTime;
    long changeInitContextCollectionProcessingTime;
    long countContexts;
    long countContextSubsumers;
    private int numOfMeasurements_ = 0;

    public long getContextCount() {
        return this.countContexts;
    }

    public long getSubsumersPerContextCount() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.countContextSubsumers / (long)this.numOfMeasurements_;
    }

    public long getChangeInitContextProcessingTime() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.changeInitContextProcessingTime / (long)this.numOfMeasurements_;
    }

    public long getChangeInitContextCollectionProcessingTime() {
        if (!this.measurementsTaken()) {
            return 0L;
        }
        return this.changeInitContextCollectionProcessingTime / (long)this.numOfMeasurements_;
    }

    public void reset() {
        this.changeInitContextProcessingTime = 0L;
        this.changeInitContextCollectionProcessingTime = 0L;
        this.countContexts = 0L;
        this.countContextSubsumers = 0L;
        this.numOfMeasurements_ = 0;
    }

    public synchronized void add(IncrementalProcessingStatistics stats) {
        if (stats.measurementsTaken()) {
            this.numOfMeasurements_ += stats.numOfMeasurements_;
            this.changeInitContextProcessingTime += stats.changeInitContextProcessingTime;
            this.changeInitContextCollectionProcessingTime += stats.changeInitContextCollectionProcessingTime;
            this.countContexts += stats.countContexts;
            this.countContextSubsumers += stats.countContextSubsumers;
        }
    }

    public void startMeasurements() {
        if (this.numOfMeasurements_ < 1) {
            this.numOfMeasurements_ = 1;
        }
    }

    private boolean measurementsTaken() {
        return this.numOfMeasurements_ > 0;
    }

    public void print(Logger logger, Priority level) {
        if (!logger.isDebugEnabled() || !this.measurementsTaken()) {
            return;
        }
        if (this.changeInitContextProcessingTime > 0L) {
            logger.log(level, "Total context processing time during change initialization: " + this.changeInitContextProcessingTime / (long)this.numOfMeasurements_);
        }
    }
}

