/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.LinkRule;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.hashing.HashGenerator;

public abstract class IndexedClassExpression
extends IndexedObject
implements Comparable<IndexedClassExpression> {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedClassExpression.class);
    ChainableRule<Context> compositionRuleHead;
    int positiveOccurrenceNo = 0;
    int negativeOccurrenceNo = 0;
    private final int hashCode_ = HashGenerator.generateNextHashCode();
    private volatile Context context_ = null;

    @Override
    public boolean occurs() {
        return this.positiveOccurrenceNo > 0 || this.negativeOccurrenceNo > 0;
    }

    public boolean occursNegatively() {
        return this.negativeOccurrenceNo > 0;
    }

    public boolean occursPositively() {
        return this.positiveOccurrenceNo > 0;
    }

    public String printOccurrenceNumbers() {
        return "[pos=" + this.positiveOccurrenceNo + "; neg=" + this.negativeOccurrenceNo + "]";
    }

    public void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this.toString() + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.positiveOccurrenceNo < 0 || this.negativeOccurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    abstract void updateOccurrenceNumbers(ModifiableOntologyIndex var1, int var2, int var3, int var4);

    void updateAndCheckOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        this.updateOccurrenceNumbers(index, increment, positiveIncrement, negativeIncrement);
        this.checkOccurrenceNumbers();
    }

    public Context getContext() {
        return this.context_;
    }

    public synchronized boolean setContext(Context context) {
        if (this.context_ != null) {
            return false;
        }
        this.context_ = context;
        return true;
    }

    public synchronized void resetContext() {
        this.context_ = null;
    }

    public final int hashCode() {
        return this.hashCode_;
    }

    @Override
    public int compareTo(IndexedClassExpression o) {
        if (this == o) {
            return 0;
        }
        if (this.hashCode_ == o.hashCode_) {
            return this.toString().compareTo(o.toString());
        }
        return this.hashCode_ < o.hashCode_ ? -1 : 1;
    }

    public LinkRule<Context> getCompositionRuleHead() {
        return this.compositionRuleHead;
    }

    Chain<ChainableRule<Context>> getCompositionRuleChain() {
        return new AbstractChain<ChainableRule<Context>>(){

            @Override
            public ChainableRule<Context> next() {
                return IndexedClassExpression.this.compositionRuleHead;
            }

            @Override
            public void setNext(ChainableRule<Context> tail) {
                IndexedClassExpression.this.compositionRuleHead = tail;
            }
        };
    }

    @Override
    public <O> O accept(IndexedObjectVisitor<O> visitor) {
        return this.accept((IndexedClassExpressionVisitor<O>)visitor);
    }

    public abstract <O> O accept(IndexedClassExpressionVisitor<O> var1);

    public abstract void accept(DecompositionRuleApplicationVisitor var1, Context var2);
}

